/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.processing;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.extension.ExtensionRegistry;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessor;
import com.sap.core.connectivity.spi.processing.TargetHost;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelProvidedServices;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelChannelUnregisteredEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryListenerAdapter;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class OutboundPacketProcessor
implements MessagePacketProcessor {
    private static final Logger log = Logger.getLogger(OutboundPacketProcessor.class);
    private final ExtensionRegistry extensionRegistry;
    private final ConcurrentHashMap<Integer, OutboundProtocolProcessor> protocolProcessors = new ConcurrentHashMap();

    public OutboundPacketProcessor(ConnectivityContext connectivityContext) {
        this.extensionRegistry = (ExtensionRegistry)TunnelProvidedServices.getService(ExtensionRegistry.class);
        connectivityContext.getTunnelRegistry().addListener(new TunnelChannelUnregisteredOutboundListener());
    }

    @Override
    public boolean acceptsPacket(MessagePacket packet) {
        return "system".equals(packet.getOwner());
    }

    @Override
    public boolean processPacket(MessagePacket packet, Channel channel, ProcessingContext processingContext) {
        try {
            switch (packet.getType()) {
                case 1: {
                    this.openOutboundConnection(packet, processingContext);
                    break;
                }
                case 2: {
                    this.closeOutboundConnection(packet);
                    break;
                }
                case 3: {
                    this.writePayload((PayloadMessagePacket)packet);
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, packet.getConnectionId(), processingContext);
        }
        return false;
    }

    private void openOutboundConnection(MessagePacket openConnectionPacket, ProcessingContext processingContext) {
        String protocolStr = openConnectionPacket.getProperty("connectionProtocol");
        ConnectionProtocol protocol = ConnectionProtocol.valueOf((String)protocolStr);
        String host = openConnectionPacket.getProperty("host");
        String port = openConnectionPacket.getProperty("port");
        TargetHost targetHost = new TargetHost(host, port, protocol);
        OutboundProtocolProcessor outboundConnectionProcessor = this.extensionRegistry.getOutboundProtocolProcessor(targetHost, processingContext);
        this.protocolProcessors.put(openConnectionPacket.getConnectionId(), outboundConnectionProcessor);
        outboundConnectionProcessor.openConnection(openConnectionPacket.getConnectionId(), targetHost);
    }

    private void closeOutboundConnection(MessagePacket closeConnectionPacket) {
        OutboundProtocolProcessor processor = this.protocolProcessors.remove(closeConnectionPacket.getConnectionId());
        if (processor != null) {
            processor.closeConnection(closeConnectionPacket.getConnectionId());
        }
    }

    private void writePayload(PayloadMessagePacket packet) {
        OutboundProtocolProcessor processor = this.protocolProcessors.get(packet.getConnectionId());
        if (processor != null) {
            ReferenceCountUtil.retain((Object)packet);
            processor.write(packet.getConnectionId(), packet.getPayload());
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("Sent packet with size {0} to processor", packet.getPayload().writerIndex()));
            }
        }
    }

    private void handleException(Exception cause, int connectionId, ProcessingContext processingContext) {
        block2: {
            log.error((Object)"Internal error", (Throwable)cause);
            MessagePacket packet = processingContext.getMessagePacketFactory().createErrorPacket((Throwable)cause, connectionId);
            try {
                processingContext.getTunnel().write(packet);
            }
            catch (NoChannelsAvailableException e) {
                log.error((Object)"No channels available", (Throwable)e);
                if ($assertionsDisabled || AssertionUtil.propagateException((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
    }

    public List<OutboundProtocolProcessor> getProcessors() {
        return Collections.unmodifiableList(new ArrayList<OutboundProtocolProcessor>(this.protocolProcessors.values()));
    }

    class TunnelChannelUnregisteredOutboundListener
    extends TunnelRegistryListenerAdapter {
        TunnelChannelUnregisteredOutboundListener() {
        }

        @Override
        public void tunnelChannelUnregistered(TunnelChannelUnregisteredEvent event) {
            for (Integer connectionId : event.getClosedConnections()) {
                if (!OutboundPacketProcessor.this.protocolProcessors.containsKey(connectionId)) continue;
                OutboundProtocolProcessor protocolProcessor = (OutboundProtocolProcessor)OutboundPacketProcessor.this.protocolProcessors.remove(connectionId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing connection with id: " + ChannelUtil.formatConnectionId((int)connectionId)));
                }
                protocolProcessor.closeConnection(connectionId.intValue());
            }
        }
    }
}

