/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.processing;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import io.netty.channel.Channel;
import org.apache.log4j.Logger;

public class ResponsePacketProcessor
implements MessagePacketProcessor {
    private static final Logger log = Logger.getLogger(ResponsePacketProcessor.class);
    private final ConnectivityContext context;

    public ResponsePacketProcessor(ConnectivityContext context) {
        this.context = context;
    }

    @Override
    public boolean acceptsPacket(MessagePacket packet) {
        return packet.getProperty("responseId") != null;
    }

    @Override
    public boolean processPacket(MessagePacket packet, Channel channel, ProcessingContext processingContext) {
        int responseId = Integer.parseInt(packet.getProperty("responseId"));
        String tunnelId = packet.getProperty("tunnelId");
        try {
            Tunnel tunnel = this.context.getTunnelRegistry().getTunnel(tunnelId);
            tunnel.responseReceived(responseId, packet);
        }
        catch (NoChannelsAvailableException e) {
            log.error((Object)("Discarding synchronous message response with id '" + responseId + "'"));
            AssertionUtil.propagateException((Throwable)e);
        }
        return false;
    }
}

