/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.processing;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.statistics.PerformanceStatistics;
import com.sap.core.connectivity.spi.statistics.TimeStatistic;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import io.netty.channel.Channel;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class TunnelSubscribingProcessor
implements MessagePacketProcessor {
    private static final Logger log = Logger.getLogger(TunnelSubscribingProcessor.class);
    private final ConnectivityContext context;

    public TunnelSubscribingProcessor(ConnectivityContext context) {
        this.context = context;
    }

    @Override
    public boolean acceptsPacket(MessagePacket packet) {
        return "system".equals(packet.getOwner());
    }

    @Override
    public boolean processPacket(MessagePacket packet, Channel channel, ProcessingContext processingContext) {
        try {
            switch (packet.getType()) {
                case 1: {
                    this.subscribeConnection(packet, processingContext);
                    break;
                }
                case 2: {
                    this.unsubscribeConnection(packet, processingContext);
                    break;
                }
                case 3: {
                    this.measureConnection(packet, processingContext);
                    break;
                }
                default: {
                    log.trace((Object)("Unknown packet type: " + packet.getType()));
                    break;
                }
            }
        }
        catch (NoChannelsAvailableException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    private void measureConnection(MessagePacket packet, ProcessingContext processingContext) {
        PerformanceStatistics stats = processingContext.getPerformanceStatistics(packet.getConnectionId());
        TimeStatistic totalTime = stats.getTotalTime();
        if (!totalTime.isMeasureStarted()) {
            totalTime.startMeasure();
        }
    }

    private void subscribeConnection(MessagePacket openConnectionPacket, ProcessingContext processingContext) throws NoChannelsAvailableException {
        int connectionId = openConnectionPacket.getConnectionId();
        PerformanceStatistics stats = processingContext.getPerformanceStatistics(connectionId);
        TimeStatistic totalTime = stats.getTotalTime();
        totalTime.startMeasure();
        Tunnel tunnel = this.context.getTunnelRegistry().getTunnel(processingContext.getTunnel().getId());
        int tunnelChannelId = Integer.parseInt(openConnectionPacket.getProperty("tunnelChannelId"));
        String tunnelId = openConnectionPacket.getProperty("tunnelId");
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Received subscription request for connection ID: {0} to tunnel channel id: {1}. Tunnel id: \"{2}\"", connectionId, tunnelChannelId, tunnelId));
        }
        tunnel.subscribe(connectionId, tunnelChannelId);
    }

    private void unsubscribeConnection(MessagePacket closeConnectionPacket, ProcessingContext processingContext) throws NoChannelsAvailableException {
        Tunnel tunnel = this.context.getTunnelRegistry().getTunnel(processingContext.getTunnel().getId());
        tunnel.unsubscribe(closeConnectionPacket.getConnectionId());
        int connectionId = closeConnectionPacket.getConnectionId();
        PerformanceStatistics stats = processingContext.getPerformanceStatistics(connectionId);
        stats.release();
    }
}

