/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.protocol;

import com.sap.core.connectivity.spi.TunnelException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.tunnel.core.context.SystemMessagePacketFactory;
import com.sap.core.connectivity.tunnel.core.impl.protocol.MessagePacketImpl;
import com.sap.core.connectivity.tunnel.core.impl.protocol.PayloadMessagePacketImpl;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class MessagePacketFactoryImpl
implements SystemMessagePacketFactory {
    private AtomicInteger requestId = new AtomicInteger(0);

    public MessagePacket createMessagePacket(String owner, int type) {
        return new MessagePacketImpl(owner, type);
    }

    public MessagePacket createMessagePacket(String owner, int type, int connectionId) {
        return new MessagePacketImpl(owner, type, connectionId);
    }

    public PayloadMessagePacket createPayloadPacket(int connectionId, ByteBuf payload) {
        return new PayloadMessagePacketImpl("system", 3, connectionId, payload);
    }

    public PayloadMessagePacket createPayloadPacket(String owner, int type, ByteBuf payload) {
        return new PayloadMessagePacketImpl(owner, type, payload);
    }

    public PayloadMessagePacket createPayloadPacket(String owner, int type, int connectionId, ByteBuf payload) {
        return new PayloadMessagePacketImpl(owner, type, connectionId, payload);
    }

    public MessagePacket createErrorPacket(int connectionId, int errorCode, String message) {
        if (message == null) {
            throw new IllegalArgumentException("Need a non-null message for creating an error packet");
        }
        MessagePacket messagePacket = this.createMessagePacket("system", 4, connectionId);
        messagePacket.setProperty("errorCode", Integer.toString(errorCode));
        messagePacket.setProperty("errorMessage", message);
        return messagePacket;
    }

    public MessagePacket createErrorPacket(Throwable cause, int tag) {
        int errorCode = cause instanceof TunnelException ? ((TunnelException)cause).getErrorCode() : 100;
        String message = cause != null && cause.getMessage() != null ? cause.getMessage() : "There is no error message";
        return this.createErrorPacket(tag, errorCode, message);
    }

    @Override
    public MessagePacket createOpenConnectionPacket(int tag, String host, int port, Properties properties) {
        MessagePacket messagePacket = this.createMessagePacket("system", 1, tag);
        messagePacket.setProperty("host", host);
        messagePacket.setProperty("port", Integer.toString(port));
        for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
            messagePacket.setProperty((String)propertyEntry.getKey(), (String)propertyEntry.getValue());
        }
        return messagePacket;
    }

    @Override
    public MessagePacket createCloseConnectionPacket(int tag) {
        return this.createMessagePacket("system", 2, tag);
    }

    @Override
    public MessagePacket createRequestPacket(String owner, int type) {
        MessagePacket messagePacket = this.createMessagePacket(owner, type);
        messagePacket.setProperty("requestId", Integer.toString(this.requestId.incrementAndGet()));
        return messagePacket;
    }

    @Override
    public MessagePacket createResponsePacket(MessagePacket request) {
        MessagePacket messagePacket = this.createMessagePacket(request.getOwner(), request.getType());
        String responseId = request.getProperty("requestId");
        messagePacket.setProperty("responseId", responseId);
        return messagePacket;
    }

    @Override
    public PayloadMessagePacket createResponsePacket(MessagePacket request, ByteBuf payload) {
        PayloadMessagePacket messagePacket = this.createPayloadPacket(request.getOwner(), request.getType(), payload);
        String responseId = request.getProperty("requestId");
        messagePacket.setProperty("responseId", responseId);
        return messagePacket;
    }

    public MessagePacket createOpenConnectionResponseMessagePacket(int connectionId) {
        MessagePacket messagePacket = this.createMessagePacket("system", 5, connectionId);
        return messagePacket;
    }
}

