/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.protocol;

import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.tunnel.core.impl.protocol.MessagePacketImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.IllegalReferenceCountException;

public class PayloadMessagePacketImpl
extends MessagePacketImpl
implements PayloadMessagePacket,
ByteBufHolder {
    private final ByteBuf data;

    public PayloadMessagePacketImpl(String owner, int type, ByteBuf payload) {
        super(owner, type);
        this.data = payload;
    }

    public PayloadMessagePacketImpl(String owner, int type, int connectionId, ByteBuf payload) {
        super(owner, type, connectionId);
        this.data = payload;
    }

    public ByteBuf getPayload() {
        return this.data;
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int decrement) {
        return this.data.release(decrement);
    }

    public PayloadMessagePacketImpl retain() {
        this.data.retain();
        return this;
    }

    public PayloadMessagePacketImpl retain(int increment) {
        this.data.retain(increment);
        return this;
    }

    public PayloadMessagePacketImpl touch() {
        this.data.touch();
        return this;
    }

    public PayloadMessagePacketImpl touch(Object obj) {
        this.data.touch(obj);
        return this;
    }

    public ByteBuf content() {
        if (this.data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.data.refCnt());
        }
        return this.data;
    }

    public PayloadMessagePacketImpl copy() {
        return this.replace(this.content().copy());
    }

    public PayloadMessagePacketImpl duplicate() {
        return this.replace(this.content().duplicate());
    }

    public PayloadMessagePacketImpl retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    public PayloadMessagePacketImpl replace(ByteBuf content) {
        return new PayloadMessagePacketImpl(this.getOwner(), this.getType(), this.getConnectionId(), content);
    }
}

