/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.proxy;

import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractProxyServer {
    protected Logger log = Logger.getLogger(this.getClass());
    protected final int portNumber;
    protected final boolean allowRemoteConnections;
    protected final ConnectivityContext connectivityContext;
    private Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public AbstractProxyServer(int portNumber, boolean allowRemoteConnections, ConnectivityContext connectivityContext) {
        this.portNumber = portNumber;
        this.allowRemoteConnections = allowRemoteConnections;
        this.connectivityContext = connectivityContext;
    }

    public int start() throws PortUnavailableException {
        InetSocketAddress proxyBindAddress;
        if (this.allowRemoteConnections) {
            proxyBindAddress = new InetSocketAddress(this.portNumber);
        } else {
            try {
                proxyBindAddress = new InetSocketAddress(InetAddress.getByName(null), this.portNumber);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to get loopback interface address");
            }
        }
        TunnelConfiguration configuration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
        this.bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(this.getName() + "-boss"));
        this.workerGroup = new NioEventLoopGroup(configuration.getProxyPoolSize(), (ThreadFactory)new DefaultThreadFactory(this.getName()));
        ServerBootstrap bootstrap = new ServerBootstrap();
        ChannelInitializer<Channel> initializer = this.createChannelInitializer();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(initializer).childOption(ChannelOption.TCP_NODELAY, (Object)configuration.getProxyTCPNoDelay());
        int channelWriteBufferSize = configuration.getClientChannelWriteBufferSize();
        if (channelWriteBufferSize >= 0) {
            bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(channelWriteBufferSize / 2, channelWriteBufferSize));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)bootstrap.toString());
        }
        try {
            ChannelFuture bootstrapFuture = bootstrap.bind((SocketAddress)proxyBindAddress);
            bootstrapFuture.syncUninterruptibly();
            this.channel = bootstrapFuture.channel();
            int actualPort = ((InetSocketAddress)this.channel.localAddress()).getPort();
            this.log.info((Object)("Started proxy server at port: " + actualPort));
            this.log.info((Object)("Proxy server pool size: " + configuration.getProxyPoolSize()));
            this.log.info((Object)("Proxy server max heap per channel: " + configuration.getProxyMaxMemo()));
            this.log.info((Object)("Proxy server max heap for all channels: " + configuration.getProxyMaxTotalMemo()));
            return actualPort;
        }
        catch (ChannelException e) {
            if (e.getCause() instanceof BindException) {
                throw new PortUnavailableException(String.format("Cloud not start proxy server on port %d: %s", this.portNumber, e.getCause().getMessage()));
            }
            throw e;
        }
    }

    protected abstract ChannelInitializer<Channel> createChannelInitializer();

    protected abstract String getName();

    public void stop() {
        int actualPort = this.closeBootstrapChannel();
        this.shutdownEventLoops(0L, 15L, TimeUnit.SECONDS);
        this.log.info((Object)("Stopped proxy server at port: " + actualPort));
    }

    public void shutdown() {
        int actualPort = this.closeBootstrapChannel();
        this.shutdownEventLoops(0L, 0L, TimeUnit.SECONDS);
        this.log.info((Object)("Shut down proxy server at port: " + actualPort));
    }

    private void shutdownEventLoops(long quietPeriod, long timeout, TimeUnit unit) {
        Future workerShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, unit);
        Future bossShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, unit);
        workerShutdownFuture.awaitUninterruptibly();
        bossShutdownFuture.awaitUninterruptibly();
    }

    private int closeBootstrapChannel() {
        int actualPort = ((InetSocketAddress)this.channel.localAddress()).getPort();
        ChannelUtil.close((Channel)this.channel);
        return actualPort;
    }
}

