/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.proxy;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.handlers.DefaultErrorHandler;
import com.sap.core.connectivity.tunnel.core.impl.proxy.ForwardingProxyInboundRequestProcessorHandler;
import com.sap.core.connectivity.tunnel.core.impl.proxy.InboundLoggingHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;

class ForwardingProxyChannelInitializer
extends ChannelInitializer<Channel> {
    private final String tunnelId;
    private final String mappingId;
    private final ConnectionProtocol connectionProtocol;
    private final ConnectivityContext connectivityContext;

    public ForwardingProxyChannelInitializer(String tunnelId, String mappingId, ConnectionProtocol connectionProtocol, ConnectivityContext connectivityContext) {
        this.tunnelId = tunnelId;
        this.mappingId = mappingId;
        this.connectionProtocol = connectionProtocol;
        this.connectivityContext = connectivityContext;
    }

    protected void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("loggingHandler", (ChannelHandler)new InboundLoggingHandler());
        pipeline.addLast("inboundRequestProcessorHandler", (ChannelHandler)new ForwardingProxyInboundRequestProcessorHandler(this.tunnelId, this.mappingId, this.connectionProtocol, this.connectivityContext));
        pipeline.addLast("clientProxyErrorHandler", (ChannelHandler)new DefaultErrorHandler(this.connectivityContext, "forwarding-proxy"));
    }
}

