/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.proxy;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import com.sap.core.connectivity.tunnel.core.impl.proxy.ProxyInboundRequestProcessorHandler;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.Logger;

class ForwardingProxyInboundRequestProcessorHandler
extends ProxyInboundRequestProcessorHandler {
    private static final Logger log = Logger.getLogger(ForwardingProxyInboundRequestProcessorHandler.class);
    private final String tunnelId;
    private final String mappingId;
    private final ConnectionProtocol connectionProtocol;
    private final TunnelRegistry tunnelRegistry;

    public ForwardingProxyInboundRequestProcessorHandler(String tunnelId, String mappingId, ConnectionProtocol connectionProtocol, ConnectivityContext connectivityContext) {
        super(connectivityContext);
        this.tunnelId = tunnelId;
        this.mappingId = mappingId;
        this.connectionProtocol = connectionProtocol;
        this.tunnelRegistry = connectivityContext.getTunnelRegistry();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel inboundChannel = ctx.channel();
        Integer connectionId = ConnectionId.get(inboundChannel);
        inboundChannel.config().setAutoRead(false);
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("tunnelId", this.tunnelId);
        connectionProperties.setProperty("connectionProtocol", this.connectionProtocol.toString());
        this.connectivityContext.getInboundConnectionRegistry().registerInboundConnection(this.tunnelId, inboundChannel, this.connectionProtocol);
        this.tunnelRegistry.getTunnel(this.tunnelId).subscribe(connectionId);
        MessagePacket openConnectionPacket = this.connectivityContext.getMessagePacketFactory().createOpenConnectionPacket(connectionId, this.mappingId, 0, connectionProperties);
        this.tunnelRegistry.getTunnel(this.tunnelId).writeToSubscribedChannel(connectionId, openConnectionPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Registered {0} inbound channel {1} for address {2} with connection id {3}", this.connectionProtocol.name(), inboundChannel, this.mappingId, ChannelUtil.formatConnectionId((int)connectionId)));
        }
        inboundChannel.config().setAutoRead(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabled traffic to backend system for channel " + inboundChannel));
        }
    }
}

