/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.proxy;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.processing.flow.DemandReadEvent;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.InboundConnectionRegistry;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ProxyInboundRequestProcessorHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final String FLOW_CONTROL_HANDLER_NAME = "flowControlHandler";
    private final Logger log = Logger.getLogger(ProxyInboundRequestProcessorHandler.class);
    protected final ConnectivityContext connectivityContext;
    protected final InboundConnectionRegistry inboundConnectionRegistry;
    private final boolean isMemorySafeMode;
    private final long tunnelWriteWarningThresholdMillis;
    private boolean isChannelReadComplete;

    public ProxyInboundRequestProcessorHandler(ConnectivityContext connectivityContext) {
        this.connectivityContext = connectivityContext;
        this.inboundConnectionRegistry = connectivityContext.getInboundConnectionRegistry();
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)connectivityContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.isMemorySafeMode = tunnelConfiguration.getServerMemorySafeMode();
        this.tunnelWriteWarningThresholdMillis = tunnelConfiguration.getServerTunnelWriteWarningThresholdMillis();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().addBefore(ctx.name(), FLOW_CONTROL_HANDLER_NAME, (ChannelHandler)new FlowControlHandler());
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().remove(FLOW_CONTROL_HANDLER_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block10: {
            Channel inboundChannel = ctx.channel();
            Integer connectionId = ConnectionId.get(ctx.channel());
            Tunnel tunnel = null;
            try {
                tunnel = this.inboundConnectionRegistry.getTunnel(connectionId);
                if (tunnel != null) {
                    MessagePacket closeConnectionPacket = this.connectivityContext.getMessagePacketFactory().createCloseConnectionPacket(connectionId);
                    tunnel.writeToSubscribedChannel(connectionId, closeConnectionPacket);
                }
                this.inboundConnectionRegistry.unregisterInboundConnection(inboundChannel);
                if (tunnel == null) break block10;
                tunnel.unsubscribe(connectionId);
            }
            catch (NoChannelsAvailableException noChannelsAvailableException) {
                this.inboundConnectionRegistry.unregisterInboundConnection(inboundChannel);
                if (tunnel != null) {
                    tunnel.unsubscribe(connectionId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)MessageFormat.format("Unregistered inbound channel: {0}", inboundChannel));
                    }
                }
                catch (Throwable throwable) {
                    this.inboundConnectionRegistry.unregisterInboundConnection(inboundChannel);
                    if (tunnel != null) {
                        tunnel.unsubscribe(connectionId);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)MessageFormat.format("Unregistered inbound channel: {0}", inboundChannel));
                        }
                    }
                    throw throwable;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)MessageFormat.format("Unregistered inbound channel: {0}", inboundChannel));
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.isChannelReadComplete = false;
        final Channel clientChannel = ctx.channel();
        int connectionId = ConnectionId.get(clientChannel);
        final Tunnel tunnel = this.inboundConnectionRegistry.getTunnel(connectionId);
        if (tunnel == null) {
            throw new IllegalStateException("Unable to get tunnel for inbound connection with id " + ChannelUtil.formatConnectionId((int)connectionId));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)MessageFormat.format("Receive payload with size {0} from client channel {1}. Will send it via tunnel channel {2}. Tunnel id: {3}", msg.writerIndex(), clientChannel, tunnel.getSubscribedChannel(connectionId), tunnel.getId()));
        }
        final PayloadMessagePacket payloadPacket = this.connectivityContext.getMessagePacketFactory().createPayloadPacket(connectionId, msg);
        final ChannelConfig clientChannelConfig = clientChannel.config();
        final ChannelFuture tunnelWriteFuture = tunnel.writeToSubscribedChannel(connectionId, (MessagePacket)payloadPacket);
        final Channel tunnelChannel = tunnelWriteFuture.channel();
        tunnelWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){
            private final long startTimeMillis = System.currentTimeMillis();
            private final boolean stopReadingFromClient;
            {
                boolean bl = this.stopReadingFromClient = ProxyInboundRequestProcessorHandler.this.isMemorySafeMode && !tunnelWriteFuture.channel().isWritable() && clientChannelConfig.isAutoRead();
                if (this.stopReadingFromClient) {
                    clientChannelConfig.setAutoRead(false);
                    if (ProxyInboundRequestProcessorHandler.this.log.isTraceEnabled()) {
                        ProxyInboundRequestProcessorHandler.this.log.trace((Object)MessageFormat.format("Set autoread=FALSE on Client channel: {0}; Tunnel channel: {1} {2}", clientChannel, tunnelChannel, ChannelUtil.getChannelStateDetails((Channel)tunnelChannel)));
                    }
                }
            }

            public void operationComplete(ChannelFuture future) {
                if (ProxyInboundRequestProcessorHandler.this.log.isTraceEnabled()) {
                    ProxyInboundRequestProcessorHandler.this.log.trace((Object)MessageFormat.format("Tunnel channel write future completed. Tunnel channel: {0} {1}", tunnelChannel, ChannelUtil.getChannelStateDetails((Channel)tunnelChannel)));
                }
                if (this.stopReadingFromClient) {
                    DemandReadEvent demandReadEvent = DemandReadEvent.INSTANCE;
                    clientChannelConfig.setAutoRead(true);
                    if (ProxyInboundRequestProcessorHandler.this.log.isTraceEnabled()) {
                        ProxyInboundRequestProcessorHandler.this.log.trace((Object)MessageFormat.format("Set autoread=TRUE on Client channel: {0}; Tunnel channel: {1}; Trigger event {2}", clientChannel, tunnelChannel, demandReadEvent.getClass().getSimpleName()));
                    }
                    clientChannel.pipeline().fireUserEventTriggered((Object)demandReadEvent);
                }
                int payloadPacketSize = payloadPacket.getPayload().writerIndex();
                if (future.isSuccess()) {
                    long tunnelWriteTimeMillis;
                    if (ProxyInboundRequestProcessorHandler.this.log.isTraceEnabled()) {
                        ProxyInboundRequestProcessorHandler.this.log.trace((Object)MessageFormat.format("Sent message of type {0} with payload size {1} to tunnel channel {2}", payloadPacket.getType(), payloadPacketSize, tunnelChannel));
                    }
                    if ((tunnelWriteTimeMillis = System.currentTimeMillis() - this.startTimeMillis) > ProxyInboundRequestProcessorHandler.this.tunnelWriteWarningThresholdMillis) {
                        ProxyInboundRequestProcessorHandler.this.log.warn((Object)MessageFormat.format("Threshold of {0} passed. Message of type {1} with payload size {2} sent for {3} milliseconds over tunnel channel {4}. Tunnel id: \"{5}\"", ProxyInboundRequestProcessorHandler.this.tunnelWriteWarningThresholdMillis, payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), tunnelWriteTimeMillis, tunnelChannel, tunnel.getId()));
                    }
                } else {
                    Object cause = future.cause() != null ? future.cause() : "not available";
                    String failureReason = "FAILED";
                    if (future.isCancelled()) {
                        failureReason = "CANCELED";
                    }
                    ProxyInboundRequestProcessorHandler.this.log.error((Object)MessageFormat.format("Write operation {0} for message of type {1} with payload size {2} for tunnel channel {3}. Cause: {4}. Tunnel id: \"{5}\"", failureReason, payloadPacket.getType(), payloadPacketSize, tunnelChannel, cause, tunnel.getId()));
                }
            }
        });
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof DemandReadEvent) {
            if (this.isChannelReadComplete && ctx.channel().config().isAutoRead()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"userEventTriggered -> triggering ctx.read()");
                }
                ctx.read();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isChannelReadComplete = true;
        super.channelReadComplete(ctx);
    }
}

