/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.proxy;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.core.connectivity.tunnel.api.management.ProxyManagement;
import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.impl.proxy.ForwardingProxyServer;
import java.util.HashMap;
import java.util.Map;

public class ProxyManagementImpl
implements ProxyManagement {
    private final Map<Integer, ForwardingProxyServer> proxies = new HashMap<Integer, ForwardingProxyServer>();
    private final ConnectivityContext context;

    public ProxyManagementImpl(ConnectivityContext context) {
        this.context = context;
    }

    public int startProxy(String tunnelId, String mappingId, ProxyProtocol protocol) {
        ConnectionProtocol connectionProtocol = this.getConnectionProtocol(protocol);
        ForwardingProxyServer proxy = new ForwardingProxyServer(0, tunnelId, mappingId, connectionProtocol, this.context);
        try {
            int actualPort = proxy.start();
            this.proxies.put(actualPort, proxy);
            return actualPort;
        }
        catch (PortUnavailableException e) {
            throw new IllegalStateException(e);
        }
    }

    public void startProxy(int proxyPort, String tunnelId, String mappingId, ProxyProtocol protocol) throws PortUnavailableException {
        ConnectionProtocol connectionProtocol = this.getConnectionProtocol(protocol);
        ForwardingProxyServer proxy = new ForwardingProxyServer(proxyPort, tunnelId, mappingId, connectionProtocol, this.context);
        proxy.start();
        this.proxies.put(proxyPort, proxy);
    }

    public void stopProxy(int proxyPort) {
        ForwardingProxyServer proxy = this.proxies.get(proxyPort);
        if (proxy == null) {
            throw new IllegalArgumentException("There is no running proxy on port " + proxyPort);
        }
        proxy.stop();
    }

    public void stopAllProxies() {
        for (ForwardingProxyServer proxy : this.proxies.values()) {
            proxy.stop();
        }
        this.proxies.clear();
    }

    private ConnectionProtocol getConnectionProtocol(ProxyProtocol proxyProtocol) {
        switch (proxyProtocol) {
            case JDBC: {
                return ConnectionProtocol.JDBC;
            }
            case SSH: {
                return ConnectionProtocol.SSH;
            }
            case RFC: {
                return ConnectionProtocol.RFC;
            }
        }
        return ConnectionProtocol.TCP;
    }
}

