/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.protocol.generic;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessor;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessorFactory;
import com.sap.core.connectivity.tunnel.core.protocol.generic.GenericProtocolProcessor;
import org.apache.log4j.Logger;

class GenericProtocolOutboundConnectionProcessorFactory
implements OutboundProtocolProcessorFactory {
    private static final Logger log = Logger.getLogger(GenericProtocolOutboundConnectionProcessorFactory.class);

    GenericProtocolOutboundConnectionProcessorFactory() {
    }

    public synchronized OutboundProtocolProcessor getProcessor(ConnectionProtocol protocol, ProcessingContext processingContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Acquiring outbound protocol processor for protocol " + protocol));
        }
        return this.createProcessor(protocol, processingContext);
    }

    private OutboundProtocolProcessor createProcessor(ConnectionProtocol protocol, ProcessingContext processingContext) {
        log.debug((Object)("Creating outbound protocol processor for protocol " + protocol));
        switch (protocol) {
            case TCP: {
                return new GenericProtocolProcessor(processingContext);
            }
        }
        throw new IllegalArgumentException("Unsupported protocol " + protocol);
    }
}

