/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.rest.client;

import com.sap.core.connectivity.tunnel.api.info.HeaderProvider;
import com.sap.core.connectivity.tunnel.core.rest.client.DefaultHttpRequestRetryStrategy;
import com.sap.core.connectivity.tunnel.core.rest.client.HttpRequestRetryStrategy;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClientCommunicationException;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClientImpl;
import java.net.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class AutoRetryRESTClientImpl
extends RESTClientImpl {
    private static final int MAX_RETRY_COUNT = 3;

    AutoRetryRESTClientImpl(SSLContext sslContext, Proxy proxy) {
        super(sslContext, proxy);
    }

    AutoRetryRESTClientImpl(SSLSocketFactory sslFactory, Proxy proxy) {
        super(sslFactory, proxy);
    }

    @Override
    String executeRequest(final String requestUrl, final RESTClientImpl.RequestType requestType, final String requestBody, final HeaderProvider headers) throws RESTClientCommunicationException {
        HttpRequestRetryStrategy retryStrategy = this.getRetryStrategy(requestUrl);
        Callable<String> executeRequest = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AutoRetryRESTClientImpl.this.doExecuteRequest(requestUrl, requestType, requestBody, headers);
            }
        };
        return this.executeRequestWithRetry(retryStrategy, executeRequest);
    }

    protected HttpRequestRetryStrategy getRetryStrategy(String requestUrl) {
        return new DefaultHttpRequestRetryStrategy(requestUrl, 3, TimeUnit.SECONDS.toMillis(1L));
    }

    String executeRequestWithRetry(HttpRequestRetryStrategy retryStrategy, Callable<String> executeRequest) throws RESTClientCommunicationException {
        RESTClientCommunicationException responseError = null;
        String responseString = null;
        for (int i = 0; i < retryStrategy.getMaxRetryCount() + 1; ++i) {
            responseError = null;
            responseString = null;
            try {
                responseString = executeRequest.call();
            }
            catch (RESTClientCommunicationException e) {
                responseError = e;
            }
            catch (Exception e) {
                responseError = new RESTClientCommunicationException(e);
            }
            int responseCode = this.getResponseCode();
            boolean shouldRetry = retryStrategy.shouldRetry(responseCode, responseError);
            if (!shouldRetry) break;
            if (!shouldRetry) continue;
            this.dealyBeforeRetry(retryStrategy);
        }
        if (responseError != null) {
            throw responseError;
        }
        return responseString;
    }

    private void dealyBeforeRetry(HttpRequestRetryStrategy retryStrategy) {
        try {
            Thread.sleep(retryStrategy.getDelay());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String doExecuteRequest(String requestUrl, RESTClientImpl.RequestType requestType, String requestBody, HeaderProvider headers) throws RESTClientCommunicationException {
        return super.executeRequest(requestUrl, requestType, requestBody, headers);
    }
}

