/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.rest.client;

import com.sap.core.connectivity.tunnel.core.rest.client.HttpRequestRetryStrategy;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.log4j.Logger;

public class DefaultHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    private static final Logger log = Logger.getLogger(DefaultHttpRequestRetryStrategy.class);
    private int retryCount = -1;
    protected final String requestUrl;
    protected final long delayInMillis;
    protected final int maxRetryCount;

    public DefaultHttpRequestRetryStrategy(String requestUrl, int maxRetryCount, long delayInMillis) {
        this.requestUrl = requestUrl;
        if (delayInMillis < 0L) {
            throw new IllegalArgumentException("delayInMillis must be bigger or equal to zero");
        }
        this.delayInMillis = delayInMillis;
        if (maxRetryCount < 0) {
            throw new IllegalArgumentException("maxRetryCount must be bigger or equal to zero");
        }
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public final boolean shouldRetry(int responseCode, Throwable error) {
        ++this.retryCount;
        if (this.isResponseSuccessful(responseCode, error)) {
            if (this.wasRequestRetried()) {
                log.info((Object)("Request was executed successfully on retry number " + this.retryCount));
            }
            return false;
        }
        if (this.isMaxRetryCountReached()) {
            log.info((Object)("Request reached max retry count of " + this.retryCount + "  " + this.requestUrl + " , last response code " + responseCode + " error: " + error));
            return false;
        }
        if (this.isExceptionThrown(error)) {
            log.error((Object)("Request to " + this.requestUrl + " caused error, request will be retried for " + (this.retryCount + 1) + " time."), error);
            return true;
        }
        if (this.isErrorResponseCode(responseCode)) {
            log.error((Object)("Request to " + this.requestUrl + " returns error response code " + responseCode + " request will be retried for " + (this.retryCount + 1) + " time."));
            return true;
        }
        return false;
    }

    protected boolean isResponseSuccessful(int responseCode, Throwable error) {
        return responseCode == HttpResponseStatus.OK.code() && error == null;
    }

    protected boolean isExceptionThrown(Throwable error) {
        return error != null;
    }

    protected boolean isErrorResponseCode(int responseCode) {
        return responseCode != HttpResponseStatus.OK.code();
    }

    private boolean isMaxRetryCountReached() {
        return this.retryCount >= this.maxRetryCount;
    }

    private boolean wasRequestRetried() {
        return this.retryCount > 0;
    }

    @Override
    public final long getDelay() {
        return this.delayInMillis;
    }

    @Override
    public final int getMaxRetryCount() {
        return this.maxRetryCount;
    }
}

