/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.rest.client;

import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.notification.rest.RESTClientSSLContextFactory;
import com.sap.core.connectivity.tunnel.core.rest.client.AutoRetryRESTClientImpl;
import com.sap.core.connectivity.tunnel.core.rest.client.DomainDBRESTClientImpl;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClient;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClientImpl;
import java.net.Proxy;
import java.security.GeneralSecurityException;

public class RESTClientFactory {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 60000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 60000;
    private static final int DOMAINDB_CONNECT_TIMEOUT_MILLIS = 5000;
    private static final int DOMAINDB_READ_TIMEOUT_MILLIS = 8000;

    public static RESTClient createRESTClient() throws GeneralSecurityException {
        RESTClientSSLContextFactory restClientSSLContextFactory = (RESTClientSSLContextFactory)TunnelConsumableServices.getService(RESTClientSSLContextFactory.class);
        Proxy proxy = ((TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class)).getProxy();
        RESTClientImpl restClient = new RESTClientImpl(restClientSSLContextFactory.getContext(), proxy);
        restClient.setConnectTimeout(60000);
        restClient.setReadTimeout(60000);
        return restClient;
    }

    public static RESTClient createDomaindbRESTClient() throws GeneralSecurityException {
        RESTClientSSLContextFactory restClientSSLContextFactory = (RESTClientSSLContextFactory)TunnelConsumableServices.getService(RESTClientSSLContextFactory.class);
        Proxy proxy = ((TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class)).getProxy();
        DomainDBRESTClientImpl restClient = new DomainDBRESTClientImpl(restClientSSLContextFactory.getContext(), proxy);
        restClient.setConnectTimeout(5000);
        restClient.setReadTimeout(8000);
        return restClient;
    }

    public static RESTClient createAutoRetryRESTClient() throws GeneralSecurityException {
        RESTClientSSLContextFactory restClientSSLContextFactory = (RESTClientSSLContextFactory)TunnelConsumableServices.getService(RESTClientSSLContextFactory.class);
        Proxy proxy = ((TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class)).getProxy();
        AutoRetryRESTClientImpl restClient = new AutoRetryRESTClientImpl(restClientSSLContextFactory.getContext(), proxy);
        restClient.setConnectTimeout(60000);
        restClient.setReadTimeout(60000);
        return restClient;
    }
}

