/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.rest.client;

import com.sap.core.connectivity.spi.util.SSLUtil;
import com.sap.core.connectivity.tunnel.api.info.HeaderProvider;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClient;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClientCommunicationException;
import com.sap.core.connectivity.tunnel.core.rest.client.RESTClientConnectException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

class RESTClientImpl
implements RESTClient {
    private static final Logger log = Logger.getLogger(RESTClientImpl.class);
    private static final String CHARACTER_ENCODING = "UTF-8";
    private SSLSocketFactory sslFactory;
    private Proxy proxy;
    private int responseCode = -1;
    private String responseMessage = "";
    private Map<String, List<String>> headerFields;
    private int connectTimeout;
    private int readTimeout;

    RESTClientImpl(SSLContext sslContext, Proxy proxy) {
        this(new TlsOnlySSLSocketFactory(sslContext.getSocketFactory()), proxy);
    }

    RESTClientImpl(SSLSocketFactory sslFactory, Proxy proxy) {
        this.proxy = proxy;
        this.sslFactory = sslFactory;
    }

    @Override
    public String executePost(String requestUrl, HeaderProvider headers) throws RESTClientCommunicationException {
        return this.executeRequest(requestUrl, RequestType.POST, null, headers);
    }

    @Override
    public String executePost(String requestUrl, String requestBody, HeaderProvider headers) throws RESTClientCommunicationException {
        return this.executeRequest(requestUrl, RequestType.POST, requestBody, headers);
    }

    @Override
    public String executePut(String requestUrl, String requestBody, HeaderProvider headers) throws RESTClientCommunicationException {
        return this.executeRequest(requestUrl, RequestType.PUT, requestBody, headers);
    }

    @Override
    public String executeGet(String requestUrl) throws RESTClientCommunicationException {
        return this.executeRequest(requestUrl, RequestType.GET, null, null);
    }

    @Override
    public String executeGet(String requestUrl, HeaderProvider headers) throws RESTClientCommunicationException {
        return this.executeRequest(requestUrl, RequestType.GET, null, headers);
    }

    String executeRequest(String requestUrl, RequestType requestType, String requestBody, HeaderProvider headers) throws RESTClientCommunicationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Executing %1$s request for URL %2$s", new Object[]{requestType, requestUrl}));
        }
        this.responseCode = -1;
        this.responseMessage = "";
        this.headerFields = Collections.emptyMap();
        URL url = null;
        try {
            url = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            throw new RESTClientCommunicationException(String.format("Supplied URL %s not valid", requestUrl), e);
        }
        try {
            HttpURLConnection connection = this.openConnection(url);
            this.setTimeouts(connection);
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslFactory);
            }
            connection.setDoInput(true);
            if (this.isPostOrPutRequest(requestType)) {
                connection.setDoOutput(true);
            }
            connection.setRequestMethod(requestType.toString());
            if (headers != null) {
                connection = this.setConnectionRequestProperties(connection, headers);
            }
            if (this.isPostOrPutRequest(requestType) && requestBody != null) {
                this.write(connection, requestBody);
            }
            return this.readResponse(requestUrl, connection);
        }
        catch (IOException e) {
            throw new RESTClientCommunicationException("Requesting URL: " + url + " failed", e);
        }
    }

    private void setTimeouts(HttpURLConnection connection) {
        if (this.connectTimeout > 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            connection.setReadTimeout(this.readTimeout);
        }
    }

    private boolean isPostOrPutRequest(RequestType requestType) {
        return RequestType.POST.equals((Object)requestType) || RequestType.PUT.equals((Object)requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpURLConnection connection, String body) throws IOException {
        OutputStreamWriter wr = null;
        try {
            wr = new OutputStreamWriter(connection.getOutputStream(), CHARACTER_ENCODING);
            if (body != null) {
                wr.write(body);
            }
            wr.flush();
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Unable to close output stream for s2s connection.", (Throwable)e);
                }
            }
        }
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        if (this.proxy != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connecting with proxy: " + this.proxy));
            }
            return (HttpsURLConnection)url.openConnection(this.proxy);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connecting without proxy");
        }
        return (HttpURLConnection)url.openConnection();
    }

    private String readResponse(String requestUrl, HttpURLConnection connection) throws RESTClientCommunicationException {
        BufferedReader reader = null;
        try {
            this.responseCode = connection.getResponseCode();
            this.responseMessage = connection.getResponseMessage();
            this.headerFields = connection.getHeaderFields();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Executed %1$s request for URL %2$s. Response was %3$d.", connection.getRequestMethod(), requestUrl, this.responseCode));
            }
            StringBuilder responseData = new StringBuilder();
            if (this.responseCode == 200) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), CHARACTER_ENCODING));
            } else {
                InputStream errorStream = connection.getErrorStream();
                if (errorStream != null) {
                    reader = new BufferedReader(new InputStreamReader(errorStream, CHARACTER_ENCODING));
                }
            }
            if (reader != null) {
                String resultData = null;
                while ((resultData = reader.readLine()) != null) {
                    responseData.append(resultData);
                }
            }
            String string = responseData.toString();
            return string;
        }
        catch (ConnectException e) {
            throw new RESTClientConnectException("Failed to connect to notification agent", e);
        }
        catch (IOException e) {
            throw new RESTClientCommunicationException("Reading the response from URL: " + requestUrl + " failed", e);
        }
        finally {
            block17: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        if (!log.isDebugEnabled()) break block17;
                        String url = connection.getURL().toString();
                        log.debug((Object)("Could not close the buffered reader from connection: " + url), (Throwable)ioe);
                    }
                }
            }
            connection.disconnect();
        }
    }

    private HttpURLConnection setConnectionRequestProperties(HttpURLConnection connection, HeaderProvider headers) throws RESTClientCommunicationException {
        try {
            if (headers != null) {
                for (Map.Entry headerEntry : headers.getHeaders().entrySet()) {
                    connection.setRequestProperty((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new RESTClientCommunicationException("Unable to set request headers!", e);
        }
        return connection;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.headerFields;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connectTimeout = timeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.readTimeout = timeout;
    }

    private static class TlsOnlySSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory socketfactory;

        TlsOnlySSLSocketFactory(SSLSocketFactory socketfactory) {
            this.socketfactory = socketfactory;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.disableSSL(this.socketfactory.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.disableSSL(this.socketfactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.disableSSL(this.socketfactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(address, port, localAddress, localPort));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.socketfactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.socketfactory.getSupportedCipherSuites();
        }

        private Socket disableSSL(Socket socket) {
            if (!(socket instanceof SSLSocket)) {
                return socket;
            }
            return SSLUtil.disableSSLProtocols((SSLSocket)((SSLSocket)socket));
        }
    }

    static enum RequestType {
        GET,
        POST,
        PUT;

    }
}

