/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.timeout;

import com.sap.core.connectivity.tunnel.core.timeout.FutureTimeoutListener;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class FutureTimeout<F extends Future<?>> {
    private static final Timer TIMEOUT_TIMER = new HashedWheelTimer();
    private static final Object UNUSED_VALUE = new Object();
    private final ConcurrentHashMap<FutureTimeoutListener<F>, Object> listeners = new ConcurrentHashMap();
    private final F future;
    private final Timeout timeout;
    private final long timeoutNanos;

    public FutureTimeout(F future, long delay, TimeUnit unit) {
        this.future = future;
        this.timeoutNanos = unit.toNanos(delay);
        this.timeout = TIMEOUT_TIMER.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                FutureTimeout.this.notifyListeners();
            }
        }, delay, unit);
        this.future.addListener(new FutureCompleteListener());
    }

    private void notifyListeners() {
        Iterator listenersIterator = this.listeners.keySet().iterator();
        while (listenersIterator.hasNext()) {
            FutureTimeoutListener listener = (FutureTimeoutListener)listenersIterator.next();
            listener.operationTimedOut(this.future, this.timeoutNanos);
            listenersIterator.remove();
        }
    }

    public void addListener(FutureTimeoutListener<F> listener) {
        if (this.timeout.isExpired()) {
            listener.operationTimedOut(this.future, this.timeoutNanos);
        }
        this.listeners.putIfAbsent(listener, UNUSED_VALUE);
    }

    public void removeListener(FutureTimeoutListener<F> listener) {
        this.listeners.remove(listener);
    }

    private class FutureCompleteListener<T, P extends Future<T>>
    implements GenericFutureListener<P> {
        private FutureCompleteListener() {
        }

        public void operationComplete(P future) throws Exception {
            FutureTimeout.this.timeout.cancel();
        }
    }
}

