/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class CertificateUtils {
    private static final Logger logger = Logger.getLogger(CertificateUtils.class);
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String extractSubjectTokenValue(X509Certificate cert, String token) throws IllegalArgumentException {
        X500Principal principal = cert.getSubjectX500Principal();
        if (principal == null) {
            throw new IllegalArgumentException("cert.getSubjectX500Principal() returns null.");
        }
        String certificateSubject = principal.getName();
        return CertificateUtils.extractSubjectTokenValueFromPrincipalName(certificateSubject, token);
    }

    public static String extractSubjectTokenValueFromPrincipalName(String principal, String token) throws IllegalArgumentException {
        if (principal == null) {
            throw new IllegalArgumentException("provided principal is null");
        }
        String[] certificateSubjectTokens = principal.split(",");
        String tokenValue = null;
        for (String certificateToken : certificateSubjectTokens) {
            if (!(certificateToken = certificateToken.trim()).startsWith(token)) continue;
            tokenValue = certificateToken.substring(token.length());
            break;
        }
        return tokenValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate extractCertificateFromBase64String(String base64EncodedCertificate) throws GeneralSecurityException {
        InputStream is = null;
        X509Certificate cert = null;
        if (base64EncodedCertificate == null) {
            logger.debug((Object)"Expected base 64 encoded certificate but NULL is provided as value");
            throw new GeneralSecurityException("Base64 ecoded certificate is not valid");
        }
        try {
            byte[] certificateBytes = DatatypeConverter.parseBase64Binary((String)base64EncodedCertificate);
            is = new ByteArrayInputStream(certificateBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Could not close input stream for client certificate", (Throwable)e);
            }
        }
        return cert;
    }

    public static String calculateMD5Fingerprint(X509Certificate certificate) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(certificate.getEncoded());
            byte[] digest = md.digest();
            StringBuilder builder = new StringBuilder(digest.length * 2);
            for (byte b : digest) {
                builder.append(HEX_DIGITS[(b & 0xF0) >> 4]);
                builder.append(HEX_DIGITS[b & 0xF]);
                builder.append(":");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to calculate certificate fingerprint for certificate " + certificate, e);
        }
    }
}

