/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionId {
    private static final AttributeKey<Integer> CHANNEL_ID = AttributeKey.valueOf((String)(ConnectionId.class.getName() + ".CHANNEL_ID"));
    private static final ConcurrentHashMap<Integer, Channel> allIds = new ConcurrentHashMap();

    public static Integer get(Channel channel) {
        Integer id = (Integer)channel.attr(CHANNEL_ID).get();
        if (id != null) {
            return id;
        }
        return ConnectionId.allocateAndSetId(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer allocateAndSetId(Channel channel) {
        Channel channel2 = channel;
        synchronized (channel2) {
            Integer id = (Integer)channel.attr(CHANNEL_ID).get();
            if (id != null) {
                return id;
            }
            id = ConnectionId.allocateId(channel);
            channel.attr(CHANNEL_ID).set((Object)id);
            channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    allIds.remove(future.channel().attr(CHANNEL_ID).get());
                }
            });
            return id;
        }
    }

    private static Integer allocateId(Channel channel) {
        Integer id = channel.hashCode();
        while (allIds.putIfAbsent(id, channel) != null) {
            id = id + 1;
        }
        return id;
    }
}

