/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelType;
import java.net.URI;
import java.net.URISyntaxException;

public class ForwardingTunnelIdFactory {
    public static String createTunnelId(ForwardingTunnelType type, String account, String instance) {
        return ForwardingTunnelIdFactory.createTunnelId(null, null, type, account, instance);
    }

    public static String createTunnelId(String sccLocation, String cloudLandscapeDomain, ForwardingTunnelType type, String account, String instance) {
        ForwardingTunnelIdFactory.validateNotNull((Object)type);
        try {
            return new URI(type.getUriScheme(), ForwardingTunnelIdFactory.createAuthority(sccLocation, cloudLandscapeDomain), ForwardingTunnelIdFactory.createPathEntry(account) + ForwardingTunnelIdFactory.createPathEntry(instance), null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to generate tunnel identifier", e);
        }
    }

    private static String createAuthority(String sccLocation, String cloudLandscapeDomain) {
        String uriAuthority = "";
        if (cloudLandscapeDomain != null && !cloudLandscapeDomain.isEmpty()) {
            uriAuthority = cloudLandscapeDomain;
        }
        if (!uriAuthority.isEmpty() && sccLocation != null && !sccLocation.isEmpty()) {
            uriAuthority = sccLocation + "@" + cloudLandscapeDomain;
        }
        return uriAuthority;
    }

    private static String createPathEntry(String value) {
        ForwardingTunnelIdFactory.validatePathLevelArgument(value);
        return "/" + value;
    }

    private static void validateNotNull(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
    }

    private static void validateNotEmpty(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Argument cannot be empty");
        }
    }

    private static void validatePathLevelArgument(String value) {
        ForwardingTunnelIdFactory.validateNotEmpty(value);
        if (value.contains("/")) {
            throw new IllegalArgumentException("Path level entry should not contain path separator '/'");
        }
    }
}

