/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;

public enum ForwardingTunnelType {
    JDBC("jdbc"),
    SSH("ssh"),
    RFC("rfc");

    private String uriScheme;

    private ForwardingTunnelType(String uriScheme) {
        this.uriScheme = uriScheme;
    }

    public String getUriScheme() {
        return this.uriScheme;
    }

    public static boolean isUriSchemeSupported(String schema) {
        for (ForwardingTunnelType type : ForwardingTunnelType.values()) {
            if (!type.getUriScheme().equals(schema)) continue;
            return true;
        }
        return false;
    }

    public static ForwardingTunnelType fromProxyProtocol(ProxyProtocol protocol) {
        return ForwardingTunnelType.valueOf(protocol.name().toUpperCase());
    }
}

