/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

public abstract class Optional<T> {
    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Optional.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    private Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T orNull();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private static <U> U checkNotNull(U u, String message) {
        if (u == null) {
            throw new NullPointerException(message);
        }
        return u;
    }

    private static <U> U checkNotNull(U u) {
        if (u == null) {
            throw new NullPointerException();
        }
        return u;
    }

    private static final class Absent
    extends Optional<Object> {
        private static final Absent INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("value is absent");
        }

        @Override
        public Object or(Object defaultValue) {
            return Optional.checkNotNull(defaultValue, "use orNull() instead of or(null)");
        }

        @Override
        public Optional<Object> or(Optional<?> secondChoice) {
            return (Optional)Optional.checkNotNull(secondChoice);
        }

        @Override
        public Object orNull() {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }

        @Override
        public int hashCode() {
            return 1502476572;
        }

        @Override
        public String toString() {
            return "Optional.absent()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class Present<T>
    extends Optional<T> {
        private final T reference;

        Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public T or(T defaultValue) {
            Optional.checkNotNull(defaultValue, "use orNull() instead of or(null)");
            return this.reference;
        }

        @Override
        public Optional<T> or(Optional<? extends T> secondChoice) {
            Optional.checkNotNull(secondChoice);
            return this;
        }

        @Override
        public T orNull() {
            return this.reference;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Present) {
                Present other = (Present)object;
                return this.reference.equals(other.reference);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 1502476572 + this.reference.hashCode();
        }

        @Override
        public String toString() {
            return "Optional.of(" + this.reference + ")";
        }
    }
}

