/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

public class SCCVersion
implements Comparable<SCCVersion> {
    public static final String MASTER_VERSION = "masterVersion";
    public static final String SHADOW_VERSION = "shadowVersion";
    public static final SCCVersion UNKNOWN_VERSION = new SCCVersion("0");
    private String fullVersion;
    private int[] versionComponents;

    public SCCVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version is null");
        }
        this.fullVersion = version.trim();
        if (this.fullVersion.isEmpty()) {
            throw new IllegalArgumentException("Version is empty");
        }
        int spacePos = this.fullVersion.indexOf(32);
        if (spacePos >= 0) {
            this.fullVersion = this.fullVersion.substring(0, spacePos);
        }
        String[] versions = this.fullVersion.split("\\.");
        this.versionComponents = new int[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            this.versionComponents[i] = Integer.parseInt(versions[i]);
        }
    }

    public static boolean isMatchingRequiredVersion(SCCVersion masterVersion, SCCVersion shadowVersion, SCCVersion requiredVersion) {
        if (masterVersion == null) {
            return false;
        }
        if (shadowVersion == null) {
            return requiredVersion.compareTo(masterVersion) <= 0;
        }
        return requiredVersion.compareTo(masterVersion) <= 0 && requiredVersion.compareTo(shadowVersion) <= 0;
    }

    @Override
    public int compareTo(SCCVersion another) {
        int groups = Math.min(this.versionComponents.length, another.versionComponents.length);
        for (int i = 0; i < groups; ++i) {
            int diff = this.versionComponents[i] - another.versionComponents[i];
            if (diff == 0) continue;
            return diff;
        }
        return this.versionComponents.length - another.versionComponents.length;
    }

    public String toString() {
        return this.fullVersion;
    }
}

