/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelType;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdModel;
import java.net.URI;
import java.net.URISyntaxException;

public class TunnelIdParser {
    public static final String TUNNELID_SCHEME_ACCOUNT = "account";

    public TunnelIdModel parse(String tunnelId) throws URISyntaxException {
        if (tunnelId == null || tunnelId.isEmpty()) {
            throw new IllegalArgumentException("Wrong tunnel ID - cannot be null or empty string!");
        }
        URI tunnelIdUri = new URI(tunnelId);
        TunnelIdModel model = new TunnelIdModel();
        model.setScheme(tunnelIdUri.getScheme());
        String path = this.denormalizePath(tunnelIdUri.getPath());
        String[] subPaths = path.split("/");
        model.setAccount(this.extractAccountName(tunnelIdUri.getScheme(), subPaths));
        model.setLocation(this.extractLocationFromPath(tunnelIdUri.getScheme(), subPaths));
        return model;
    }

    public String extractAccountName(String tunnelId) throws URISyntaxException {
        URI tunnelIdUri = new URI(tunnelId);
        String path = this.denormalizePath(tunnelIdUri.getPath());
        String[] subPaths = path.split("/");
        return this.extractAccountName(tunnelIdUri.getScheme(), subPaths);
    }

    private String extractAccountName(String scheme, String[] subPaths) {
        if (this.isAccountScheme(scheme) || this.isForwardingTunnelScheme(scheme)) {
            if (subPaths == null || subPaths.length == 0 || subPaths[0] == null) {
                throw new IllegalArgumentException("Missing account name!");
            }
            return subPaths[0];
        }
        return null;
    }

    private String extractLocationFromPath(String scheme, String[] subPaths) {
        if (this.isAccountScheme(scheme)) {
            if (subPaths == null || subPaths.length < 2 || this.isEmpty(subPaths[1])) {
                return null;
            }
            return subPaths[1];
        }
        return null;
    }

    private String denormalizePath(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private boolean isAccountScheme(String scheme) {
        return TUNNELID_SCHEME_ACCOUNT.equals(scheme);
    }

    private boolean isForwardingTunnelScheme(String scheme) {
        return ForwardingTunnelType.isUriSchemeSupported(scheme);
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

