/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeConstants;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class TunnelVersionMatcher {
    private static final Logger log = Logger.getLogger(TunnelVersionMatcher.class);

    public int matchClientProtocolVersion(HttpRequest request) throws Exception {
        String tunnelVersionFromClient = request.headers().get("X-Tunnel-Version");
        if (tunnelVersionFromClient == null || tunnelVersionFromClient.isEmpty()) {
            throw new Exception("Supported client versions not supplied");
        }
        try {
            List<Integer> clientVersions = this.parseClientVersions(tunnelVersionFromClient);
            for (Integer clientVersion : clientVersions) {
                if (!this.isSupportedByServer(clientVersion)) continue;
                log.debug((Object)("Selected tunnel version: " + clientVersion));
                return clientVersion;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to match client and server tunnel version", (Throwable)e);
            throw e;
        }
        throw new Exception("None of the supplied tunnel versions from the client is supported: " + tunnelVersionFromClient);
    }

    private boolean isSupportedByServer(int clientVersion) {
        for (int serverVersion : TunnelHandshakeConstants.TUNNEL_SERVER_SUPPORTED_VERSIONS) {
            if (clientVersion != serverVersion) continue;
            return true;
        }
        return false;
    }

    private List<Integer> parseClientVersions(String clientVersionsString) {
        String[] versionTokens = clientVersionsString.replaceAll(" ", "").split(",");
        ArrayList<Integer> clientVersions = new ArrayList<Integer>();
        for (String versionString : versionTokens) {
            clientVersions.add(Integer.parseInt(versionString));
        }
        Collections.sort(clientVersions, new VersionComparatorReverseOrder());
        return clientVersions;
    }

    private class VersionComparatorReverseOrder
    implements Comparator<Integer> {
        private VersionComparatorReverseOrder() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2.compareTo(o1);
        }
    }
}

