/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Set;

public class WhitelistedObjectInputStream
extends ObjectInputStream {
    private Set<String> whitelist;

    public WhitelistedObjectInputStream(InputStream inputStream, Set<String> whitelist) throws IOException {
        super(inputStream);
        this.whitelist = whitelist;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass clazz) throws IOException, ClassNotFoundException {
        if (!this.whitelist.contains(clazz.getName())) {
            throw new InvalidClassException("Class not allowed for serialization: " + clazz.getName());
        }
        return super.resolveClass(clazz);
    }
}

