/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.service.auditlog;

import com.sap.core.js.logging.LoggingFieldProvider;
import com.sap.core.tenant.api.Tenant;
import com.sap.core.tenant.common.TenantData;
import org.apache.log4j.Logger;

public class TenantIdFieldProvider
implements LoggingFieldProvider {
    private final Logger logger = Logger.getLogger(TenantIdFieldProvider.class);
    private static final String TENANT_ID = "TenantId";

    public String[] getFieldDescriptions() {
        return new String[]{"This field shows tenant ID which trigered the log event"};
    }

    public String[] getFieldNames() {
        return new String[]{TENANT_ID};
    }

    public String[] getFieldValues(String loggerName) {
        TenantData tenantData = this.getTenantData();
        if (tenantData != null) {
            String tenantID = tenantData.getId();
            String tenantName = tenantData.getName();
            return new String[]{String.valueOf(tenantName) + "::" + tenantID};
        }
        this.logger.error((Object)"Tenant context is not available.");
        return new String[]{"no tenant context"};
    }

    TenantData getTenantData() {
        try {
            return Tenant.getData();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

