/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.tomcat.support;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingObjectFactory
extends com.sap.core.services.accessor.tomcat.support.DelegatingObjectFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingObjectFactory.class);
    private static List<ObjectFactory> implObjectFactories = null;

    public DelegatingObjectFactory() {
        this.osgiSupport = false;
    }

    protected List<ObjectFactory> getObjectFactories(String referenceType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((Object)this) + " - Searching for object factories... ");
        }
        ArrayList<ObjectFactory> result = new ArrayList<ObjectFactory>();
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Context classloader is set, we expect to be app classloader " + appClassLoader);
        }
        List<ObjectFactory> factoriesVisibleFromApp = DelegatingObjectFactory.getObjectFactories(referenceType, appClassLoader);
        List<ObjectFactory> factoriesVisibleOnlyFromImpl = DelegatingObjectFactory.getImplObjectFactories(referenceType, appClassLoader);
        result.addAll(factoriesVisibleFromApp);
        result.addAll(factoriesVisibleOnlyFromImpl);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((Object)this) + " - Found object factories visible from app loader " + factoriesVisibleFromApp);
            LOGGER.debug((Object)((Object)this) + " - Found object factories visible only from impl loader " + factoriesVisibleOnlyFromImpl);
        }
        return result;
    }

    static synchronized List<ObjectFactory> getImplObjectFactories(String referenceType, ClassLoader appClassLoader) {
        if (implObjectFactories == null) {
            implObjectFactories = new ArrayList<ObjectFactory>();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing impl object factories.");
            }
            ClassLoader implClassLoader = ClassloadingBridge.getImplClassLoader();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Implementation loader to be used " + implClassLoader);
            }
            if (implClassLoader != appClassLoader && appClassLoader != null && implClassLoader != appClassLoader.getParent()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Searching for object factories in impl class loader...");
                }
                List<ObjectFactory> objectFactoriesVisibleFromImplLoader = DelegatingObjectFactory.getObjectFactories(referenceType, implClassLoader);
                for (ObjectFactory factory : objectFactoriesVisibleFromImplLoader) {
                    if (!factory.getClass().getClassLoader().equals(appClassLoader.getParent())) {
                        implObjectFactories.add(factory);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(factory + " added");
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(factory + " ignored as it's accessible from app loader");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipping search from impl loader " + implClassLoader + "since it's either app loader or it's parent " + appClassLoader);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation factories already initialized " + implObjectFactories);
        }
        return implObjectFactories;
    }

    static List<ObjectFactory> getObjectFactories(String referenceType, ClassLoader classLoader) {
        ServiceLoader<ObjectFactory> serviceLoader = ServiceLoader.load(ObjectFactory.class, classLoader);
        ArrayList<ObjectFactory> result = new ArrayList<ObjectFactory>();
        try {
            for (ObjectFactory factory : serviceLoader) {
                result.add(factory);
            }
        }
        catch (ServiceConfigurationError e) {
            LOGGER.error("Cannot obtain ObjectFactory for reference " + referenceType, (Throwable)e);
        }
        return result;
    }
}

