/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.tomcat.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.naming.ContextAccessController;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingResourcesListener
implements LifecycleListener,
PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingResourcesListener.class);
    private static final String RESOURCE_STR = "resource";
    private static final String RESOURCE_ENV_REF_STR = "resourceEnvRef";
    static final String FACTORY_CLASS_NAME = "com.sap.core.services.accessor.tomcat.support.DelegatingObjectFactory";
    @Deprecated
    static final String PERSISTENCE_FACTORY_CLASS_NAME = "com.sap.jpaas.service.persistence.core.JNDIDataSourceFactory";
    static final String FACTORY_PROPERTY = "factory";
    private Object container = null;
    private NamingResourcesImpl namingResources = null;
    private boolean initialized = false;
    private final String name = "/";
    private String factoryClassName;
    static final String RESOURCE_REF_NAME = "ResourceRefName";
    private static final String DATA_SOURCE = "DataSource";

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.initialized) {
            return;
        }
        Object source = event.getSource();
        if (source == this.namingResources) {
            ContextAccessController.setWritable((Object)this.getName(), (Object)this.container);
            String name = event.getPropertyName();
            Object newValue = event.getNewValue();
            if (newValue != null && (RESOURCE_STR.equals(name) || RESOURCE_ENV_REF_STR.equals(name))) {
                ResourceBase resource = (ResourceBase)newValue;
                this.updateResource(resource);
            }
            ContextAccessController.setReadOnly((Object)this.getName());
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.container = event.getLifecycle();
        if (!(this.container instanceof Context)) {
            return;
        }
        this.namingResources = ((Context)this.container).getNamingResources();
        if ("configure_start".equals(event.getType())) {
            if (this.initialized) {
                return;
            }
            this.namingResources.addPropertyChangeListener((PropertyChangeListener)this);
            ContextResource[] resources = this.namingResources.findResources();
            this.updateResources((ResourceBase[])resources);
            resources = this.namingResources.findResourceEnvRefs();
            this.updateResources((ResourceBase[])resources);
            this.initialized = true;
        } else if ("configure_stop".equals(event.getType())) {
            if (!this.initialized) {
                return;
            }
            this.namingResources.removePropertyChangeListener((PropertyChangeListener)this);
            this.initialized = false;
        }
    }

    private void updateResource(ResourceBase resource) {
        if (resource.getName() != null) {
            this.addFactoryClassAsResourceProperty(resource);
            if (resource.getType() != null && resource.getType().contains(DATA_SOURCE)) {
                this.addResourceNameAsProperty(resource);
            }
        }
    }

    private void updateResources(ResourceBase[] resources) {
        if (resources != null) {
            for (ResourceBase resource : resources) {
                this.updateResource(resource);
            }
        }
    }

    private void addResourceNameAsProperty(ResourceBase resource) {
        if (!(resource instanceof ContextResource)) {
            return;
        }
        if (resource.getProperty(RESOURCE_REF_NAME) == null) {
            resource.setProperty(RESOURCE_REF_NAME, (Object)resource.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Injecting resource ref name as property to " + resource);
            }
        }
    }

    private void addFactoryClassAsResourceProperty(ResourceBase resource) {
        if (resource.getProperty(FACTORY_PROPERTY) == null || resource.getProperty(FACTORY_PROPERTY).equals(PERSISTENCE_FACTORY_CLASS_NAME)) {
            resource.setProperty(FACTORY_PROPERTY, (Object)this.getFactoryClassName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Injecting factory " + this.getFactoryClassName() + " to " + resource);
            }
        }
    }

    private Object getName() {
        return this.name;
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    public String getFactoryClassName() {
        if (this.factoryClassName == null) {
            return FACTORY_CLASS_NAME;
        }
        return this.factoryClassName;
    }
}

