/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.csi;

import com.sap.security.core.server.csi.util.RegexMatcher;
import com.sap.security.core.server.csi.util.RegexPattern;
import com.sap.security.core.server.csi.util.StringUtils;
import com.sap.security.core.server.csi.util.URI;
import com.sap.security.core.server.csi.util.URLDecoder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public final class URLChecker {
    private static final String[] URLProtocols = new String[]{"http", "https", "file", "ftp", "gopher", "mailto", "news", "nntp", "wais"};
    private static final String defaultEncoding = "UTF-8";
    private volatile transient URI _uriObject;
    private volatile transient String _uri;
    private volatile transient String _defaultProtocol = URLProtocols[0];
    private volatile transient ArrayList _allowedProtocols = null;
    private volatile transient ArrayList _allowedHosts = null;
    private volatile transient boolean _allowedHostMatch = false;
    private volatile transient boolean _bRestrictEnc = true;
    private volatile transient boolean _bIgnoreIEx = true;
    private volatile transient Object _threadLock = new Object();
    private static final RegexPattern scriptPattern = RegexPattern.compile("<\\s*script[^>]*>(.*)<\\s*/script\\s*>|\u0000", 66);
    private volatile transient RegexPattern _blackPattern = scriptPattern;
    private volatile transient RegexPattern _whitePattern = null;
    private int _whiteFlags = 66;

    public URLChecker() {
        this._allowedProtocols = new ArrayList();
        for (int i = 0; i < URLProtocols.length; ++i) {
            this._allowedProtocols.add(URLProtocols[i]);
        }
    }

    public URLChecker(String[] defaultProtocols) {
        if (defaultProtocols != null) {
            this._allowedProtocols = new ArrayList();
            for (int i = 0; i < defaultProtocols.length; ++i) {
                this._allowedProtocols.add(defaultProtocols[i]);
            }
        }
    }

    public URLChecker(String uri) throws MalformedURLException {
        this(uri, defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLChecker(String uri, String encoded) throws MalformedURLException {
        if (uri != null && encoded != null) {
            URI _uri = this._createURI(uri, encoded, this._bRestrictEnc, this._bIgnoreIEx);
            Object object = this._threadLock;
            synchronized (object) {
                this._uriObject = _uri;
                this._uri = uri;
                this._allowedProtocols = new ArrayList();
                for (int i = 0; i < URLProtocols.length; ++i) {
                    this._allowedProtocols.add(URLProtocols[i]);
                }
            }
        }
    }

    private URI _createURI(String uri, String encoded, boolean restrict, boolean bIgnoreIEx) throws MalformedURLException {
        if (restrict) {
            String uriString = URLChecker.urlNormalize(URLDecoder.decodeAll(uri, encoded, bIgnoreIEx));
            if (uriString.length() == 0) {
                throw new MalformedURLException("The URL is encode more than once");
            }
        } else {
            String uriString = URLChecker.urlNormalize(URLDecoder.decode(uri, encoded));
            if (uriString.length() == 0) {
                throw new MalformedURLException("The URL could not be encoded");
            }
        }
        try {
            URI uriObject = URI.create(uri);
            return uriObject;
        }
        catch (Exception e) {
            throw new MalformedURLException(e.getLocalizedMessage());
        }
    }

    private boolean _isValid(String l_uri, String l_encoding, boolean l_restrictive, boolean l_bIgnoreIEx, String l_defaultProtocol, Collection l_protocols, Collection l_hosts, RegexPattern l_whitePattern, RegexPattern l_blackPattern) throws MalformedURLException {
        RegexMatcher mat;
        String _encoding;
        if (l_uri == null) {
            throw new MalformedURLException("The URL must not be null");
        }
        if (l_uri.length() == 0) {
            return true;
        }
        URI uriObject = null;
        String protocol = null;
        String encodedURI = null;
        String urlPath = null;
        String host = null;
        String string = _encoding = l_encoding != null ? l_encoding : defaultEncoding;
        if (l_restrictive) {
            encodedURI = URLDecoder.decodeAll(l_uri, _encoding, l_bIgnoreIEx);
            if (encodedURI == null || encodedURI.length() == 0) {
                throw new MalformedURLException("The URL is encoded more than once");
            }
        } else {
            encodedURI = URLDecoder.decode(l_uri, _encoding);
            if (encodedURI == null || encodedURI.length() == 0) {
                throw new MalformedURLException("The URL could not be decoded");
            }
        }
        if (l_uri.charAt(l_uri.length() - 1) == ':') {
            if (!(l_protocols == null || l_protocols.contains(l_uri.substring(0, l_uri.length() - 1).toLowerCase(Locale.ENGLISH)) || l_uri.equalsIgnoreCase("mailto:") && l_uri.equalsIgnoreCase("news:"))) {
                throw new MalformedURLException("The protocol is not allowed");
            }
        } else {
            uriObject = URI.create(l_uri);
            protocol = uriObject.getScheme();
            urlPath = uriObject.getPath();
            host = uriObject.getHost();
            if (urlPath != null && urlPath.length() > 0) {
                if ((urlPath = URLChecker.urlNormalize(urlPath)) == null || urlPath.length() == 0) {
                    throw new MalformedURLException("Illegal null path (" + uriObject.getPath() + ") found during normalization");
                }
                if (l_restrictive && uriObject.isAbsolute() && urlPath.lastIndexOf("..") > -1 && (urlPath.startsWith("../") || urlPath.lastIndexOf("/../") > -1)) {
                    throw new MalformedURLException("Illegal path (" + uriObject.getPath() + ") found during normalization");
                }
            }
        }
        if (l_restrictive && l_whitePattern != null && !(mat = l_whitePattern.matcher(encodedURI)).find()) {
            throw new MalformedURLException("URL does not match with the white list");
        }
        if (l_restrictive && l_blackPattern != null && (mat = l_blackPattern.matcher(encodedURI)).find()) {
            throw new MalformedURLException("Illegal character \"" + StringUtils.escapeToHTML(mat.group()) + "\" at index " + mat.start() + " matched with the black list");
        }
        if (protocol == null) {
            if (l_restrictive && l_defaultProtocol != null && l_protocols != null && !l_protocols.contains(l_defaultProtocol)) {
                throw new MalformedURLException("The default protocol " + this._defaultProtocol + " is not allowed");
            }
        } else if (l_protocols != null && !l_protocols.contains(protocol.toLowerCase(Locale.ENGLISH))) {
            throw new MalformedURLException("The protocol is not allowed");
        }
        if (l_hosts != null && host != null) {
            if (this._allowedHostMatch) {
                boolean _found = false;
                for (int i = 0; i < l_hosts.size(); ++i) {
                    String elem = (String)((ArrayList)l_hosts).get(i);
                    if (!RegexPattern.matches(elem, host)) continue;
                    _found = true;
                    break;
                }
                if (!_found) {
                    throw new MalformedURLException("The host " + host + " is not allowed");
                }
            } else if (!l_hosts.contains(host)) {
                throw new MalformedURLException("The host " + host + " is not allowed");
            }
        }
        return true;
    }

    public static String urlNormalize(String url) {
        return StringUtils.urlNormalize(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object normalize() throws MalformedURLException {
        Object object = this._threadLock;
        synchronized (object) {
            return this._uriObject.normalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictive(boolean chk) {
        Object object = this._threadLock;
        synchronized (object) {
            this._bRestrictEnc = chk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreInheritedException(boolean ign) {
        Object object = this._threadLock;
        synchronized (object) {
            this._bIgnoreIEx = ign;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultProtocol(String proc) {
        Object object = this._threadLock;
        synchronized (object) {
            if (this._allowedProtocols != null) {
                if (this._allowedProtocols.contains(proc)) {
                    this._defaultProtocol = proc;
                }
            } else {
                this._defaultProtocol = proc;
            }
        }
    }

    public String getDefaultProtocol() {
        return this._defaultProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocols(String[] protocols) {
        Object object = this._threadLock;
        synchronized (object) {
            if (protocols != null) {
                if (protocols.length > 0) {
                    if (this._allowedProtocols == null) {
                        this._allowedProtocols = new ArrayList(protocols.length);
                    } else {
                        this._allowedProtocols.clear();
                    }
                    for (int i = 0; i < protocols.length; ++i) {
                        this._allowedProtocols.add(protocols[i]);
                    }
                }
                if (!this._allowedProtocols.contains(this._defaultProtocol)) {
                    throw new IllegalArgumentException("Default protocol " + this._defaultProtocol + " is not defined in protocol list.");
                }
            } else {
                if (this._allowedProtocols != null) {
                    this._allowedProtocols.clear();
                }
                this._allowedProtocols = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHosts(String[] hosts) {
        Object object = this._threadLock;
        synchronized (object) {
            if (hosts != null) {
                this._allowedHostMatch = false;
                if (hosts.length > 0) {
                    if (this._allowedHosts != null) {
                        this._allowedHosts.clear();
                    } else {
                        this._allowedHosts = new ArrayList(hosts.length);
                    }
                    for (int i = 0; i < hosts.length; ++i) {
                        if (hosts[i].indexOf(42) > -1 || hosts[i].indexOf(63) > -1) {
                            this._allowedHostMatch = true;
                        }
                        if (RegexPattern.compile(hosts[i]) == null) {
                            this._allowedHosts.clear();
                            this._allowedHosts = null;
                            throw new IllegalArgumentException("Syntax error in pattern: " + hosts[i]);
                        }
                        this._allowedHosts.add(hosts[i]);
                    }
                }
            } else {
                this._allowedHostMatch = false;
                if (this._allowedHosts != null) {
                    this._allowedHosts.clear();
                }
                this._allowedHosts = null;
            }
        }
    }

    public String[] getProtocols() {
        return this._allowedProtocols.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocol(String proc) {
        Object object = this._threadLock;
        synchronized (object) {
            if (!this._allowedProtocols.contains(proc)) {
                this._allowedProtocols.add(proc);
            }
        }
    }

    public boolean setBlackURLPattern(String pattern) {
        return this.setBlackURLPattern(pattern, 66);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBlackURLPattern(String pattern, int flags) {
        RegexPattern _pattern = null;
        if (pattern == null || pattern.length() <= 0) {
            Object object = this._threadLock;
            synchronized (object) {
                this._blackPattern = null;
            }
            return true;
        }
        _pattern = RegexPattern.compile(pattern, flags);
        if (_pattern != null) {
            Object object = this._threadLock;
            synchronized (object) {
                this._blackPattern = _pattern;
            }
            return true;
        }
        return false;
    }

    public boolean setWhiteURLPattern(String pattern) {
        return this.setWhiteURLPattern(pattern, this._whiteFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWhiteURLPattern(String pattern, int flags) {
        RegexPattern _pattern = null;
        if (pattern == null || pattern.length() <= 0) {
            Object object = this._threadLock;
            synchronized (object) {
                this._blackPattern = null;
            }
            return true;
        }
        _pattern = RegexPattern.compile(pattern, flags);
        if (_pattern != null) {
            Object object = this._threadLock;
            synchronized (object) {
                this._whitePattern = _pattern;
                this._whiteFlags = flags;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWhiteURLPattern(String pattern) throws IllegalArgumentException {
        if (pattern == null) {
            return false;
        }
        if (this._whitePattern == null) {
            return this.setWhiteURLPattern(pattern, this._whiteFlags);
        }
        RegexPattern _pattern = RegexPattern.compile(pattern, this._whiteFlags);
        StringBuffer _sBuffer = new StringBuffer();
        if (this._whitePattern.pattern() == null) {
            throw new IllegalArgumentException("Syntax error in pattern");
        }
        _sBuffer.append("(");
        _sBuffer.append(this._whitePattern.pattern());
        _sBuffer.append(")|(");
        _sBuffer.append(pattern);
        _sBuffer.append(")");
        _pattern = RegexPattern.compile(_sBuffer.toString(), this._whiteFlags);
        if (_pattern != null) {
            Object object = this._threadLock;
            synchronized (object) {
                this._whitePattern = _pattern;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws MalformedURLException {
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(this._uri, defaultEncoding, this._bRestrictEnc, this._bIgnoreIEx, this._defaultProtocol, this._allowedProtocols, this._allowedHosts, this._whitePattern, this._blackPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String uri) throws MalformedURLException {
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(uri, defaultEncoding, this._bRestrictEnc, this._bIgnoreIEx, this._defaultProtocol, this._allowedProtocols, this._allowedHosts, this._whitePattern, this._blackPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String url, boolean restrict, String[] allowedProtocols) throws MalformedURLException {
        if (allowedProtocols != null) {
            ArrayList<String> _allowedProtocols = new ArrayList<String>();
            for (int i = 0; i < allowedProtocols.length; ++i) {
                _allowedProtocols.add(allowedProtocols[i]);
            }
            return this._isValid(url, defaultEncoding, restrict, this._bIgnoreIEx, allowedProtocols[0], _allowedProtocols, this._allowedHosts, this._whitePattern, scriptPattern);
        }
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(url, defaultEncoding, restrict, this._bIgnoreIEx, this._defaultProtocol, this._allowedProtocols, this._allowedHosts, this._whitePattern, scriptPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String url, String encoding, boolean restrict, String defaultProtocol, String[] allowedProtocols, RegexPattern blackpattern) throws MalformedURLException {
        if (allowedProtocols != null) {
            ArrayList<String> _allowedProtocols = new ArrayList<String>();
            for (int i = 0; i < allowedProtocols.length; ++i) {
                _allowedProtocols.add(allowedProtocols[i]);
            }
            return this._isValid(url, encoding, restrict, this._bIgnoreIEx, defaultProtocol, _allowedProtocols, this._allowedHosts, this._whitePattern, blackpattern);
        }
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(url, encoding, restrict, this._bIgnoreIEx, defaultProtocol, null, this._allowedHosts, this._whitePattern, blackpattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String url, String encoding, boolean restrict, String defaultProtocol, String[] allowedProtocols, RegexPattern whitePattern, RegexPattern blackpattern) throws MalformedURLException {
        if (allowedProtocols != null) {
            ArrayList<String> _allowedProtocols = new ArrayList<String>();
            for (int i = 0; i < allowedProtocols.length; ++i) {
                _allowedProtocols.add(allowedProtocols[i]);
            }
            return this._isValid(url, encoding, restrict, this._bIgnoreIEx, defaultProtocol, _allowedProtocols, this._allowedHosts, whitePattern, blackpattern);
        }
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(url, encoding, restrict, this._bIgnoreIEx, defaultProtocol, null, this._allowedHosts, whitePattern, blackpattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String url, String encoding, boolean restrict, boolean ignoreInDecExcep, String defaultProtocol, String[] allowedProtocols, RegexPattern blackpattern) throws MalformedURLException {
        if (allowedProtocols != null) {
            ArrayList<String> _allowedProtocols = new ArrayList<String>();
            for (int i = 0; i < allowedProtocols.length; ++i) {
                _allowedProtocols.add(allowedProtocols[i]);
            }
            return this._isValid(url, encoding, restrict, ignoreInDecExcep, defaultProtocol, _allowedProtocols, this._allowedHosts, this._whitePattern, blackpattern);
        }
        Object object = this._threadLock;
        synchronized (object) {
            return this._isValid(url, encoding, restrict, ignoreInDecExcep, defaultProtocol, null, this._allowedHosts, this._whitePattern, blackpattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getValidURL(String uri) throws MalformedURLException {
        if (this.isValid(uri)) {
            Object object = this._threadLock;
            synchronized (object) {
                return this._uriObject.toURL();
            }
        }
        return null;
    }

    public String getValidURLString() throws MalformedURLException {
        if (this.isValid()) {
            return this._uri;
        }
        return null;
    }

    public static String getValidURLString(String url) {
        try {
            URLChecker val = new URLChecker();
            if (val.isValid(url)) {
                return val._uriObject.toString();
            }
            return null;
        }
        catch (Exception uex) {
            return null;
        }
    }

    public static boolean isValidURL(String url) {
        try {
            URLChecker val = new URLChecker();
            return val.isValid(url);
        }
        catch (Exception uex) {
            return false;
        }
    }

    public static boolean isValidURL(String url, String encoding, boolean restrict, String defaultProtocol, String[] allowedProtocols, RegexPattern blackpattern) {
        try {
            URLChecker urlChecker = new URLChecker(allowedProtocols);
            return urlChecker._isValid(url, encoding, restrict, urlChecker._bIgnoreIEx, defaultProtocol, urlChecker._allowedProtocols, urlChecker._allowedHosts, urlChecker._whitePattern, blackpattern);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidURL(String url, String encoding, boolean restrict, boolean ignoreInDecExcep, String defaultProtocol, String[] allowedProtocols, RegexPattern blackpattern) {
        try {
            URLChecker urlChecker = new URLChecker(allowedProtocols);
            return urlChecker._isValid(url, encoding, restrict, ignoreInDecExcep, defaultProtocol, urlChecker._allowedProtocols, urlChecker._allowedHosts, urlChecker._whitePattern, blackpattern);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidURL(String url, String encoding, boolean restrict, boolean ignoreInDecExcep, String defaultProtocol, String[] allowedProtocols, RegexPattern whitepattern, RegexPattern blackpattern) {
        try {
            URLChecker urlChecker = new URLChecker(allowedProtocols);
            return urlChecker._isValid(url, encoding, restrict, ignoreInDecExcep, defaultProtocol, urlChecker._allowedHosts, urlChecker._allowedProtocols, whitepattern, blackpattern);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidURL(String url, boolean restrict, String[] allowedProtocols) {
        try {
            URLChecker urlChecker = new URLChecker(allowedProtocols);
            if (urlChecker._allowedProtocols != null) {
                return urlChecker._isValid(url, defaultEncoding, restrict, urlChecker._bIgnoreIEx, allowedProtocols[0], urlChecker._allowedProtocols, urlChecker._allowedHosts, urlChecker._whitePattern, scriptPattern);
            }
            return urlChecker._isValid(url, defaultEncoding, restrict, urlChecker._bIgnoreIEx, null, null, urlChecker._allowedHosts, urlChecker._whitePattern, scriptPattern);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

