/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.impl;

import com.sap.cloud.account.InvalidTenantException;
import com.sap.cloud.account.Tenant;
import com.sap.cloud.account.TenantAlreadySetException;
import com.sap.cloud.account.TenantContext;
import com.sap.cloud.account.TenantUnavailableException;
import com.sap.cloud.account.impl.TenantImpl;
import com.sap.core.tenant.api.TenantService;
import com.sap.core.tenant.common.TenantData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class TenantContextImpl
implements TenantContext {
    private static TenantService tenantService = null;

    protected void setTenantServiceOsgi(TenantService newTenantService) {
        TenantContextImpl.setTenantService(newTenantService);
    }

    public static void setTenantService(TenantService newTenantService) {
        tenantService = newTenantService;
    }

    public <V> V execute(String tenantId, Callable<V> callable) throws TenantAlreadySetException, InvalidTenantException, Exception {
        TenantService localTenantService = tenantService;
        if (localTenantService == null) {
            throw new RuntimeException("Tenant management API is not yet initialized or is already stopped.");
        }
        return (V)localTenantService.execute(tenantId, callable);
    }

    public String getTenantId() {
        String tenantID = com.sap.core.tenant.api.Tenant.getId();
        if (tenantID == null) {
            throw new TenantUnavailableException("TenantContext is not available.");
        }
        return tenantID;
    }

    public String getAccountName() {
        String accountName = com.sap.core.tenant.api.Tenant.getAccountName();
        if (accountName == null) {
            throw new TenantUnavailableException("TenantContext is not available.");
        }
        return accountName;
    }

    public Tenant getTenant() {
        TenantData tenantData = com.sap.core.tenant.api.Tenant.getData();
        if (tenantData == null || tenantData.getId() == null || tenantData.getAccountName() == null) {
            throw new TenantUnavailableException("Tenant is not available.");
        }
        return new TenantImpl(tenantData.getId(), tenantData.getAccountName(), tenantData.getCustomerId());
    }

    public Collection<Tenant> getSubscribedTenants() {
        ArrayList<TenantImpl> result = null;
        List tenants = com.sap.core.tenant.api.Tenant.getSusbcribedTenants();
        if (tenants != null) {
            result = new ArrayList<TenantImpl>(tenants.size());
            for (TenantData tenant : tenants) {
                result.add(new TenantImpl(tenant.getId(), tenant.getAccountName(), tenant.getCustomerId()));
            }
        }
        return result;
    }
}

