/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.util.cache.LruCache;
import java.util.Properties;

public class DbsCache
extends LruCache {
    private boolean keepStats;
    private int hits = 0;
    private int misses = 0;

    public DbsCache(Properties info) {
        super(ParseinfoCache.getSizeProperty(info));
        this.setOptions(info);
    }

    private void setOptions(Properties info) {
        String kindDecl = info.getProperty("cache");
        this.keepStats = kindDecl.indexOf(63) >= 0;
    }

    public void use(String sqlCmd) {
        Object cachedItem = this.get(sqlCmd);
        if (cachedItem != null) {
            ++this.hits;
        } else {
            ++this.misses;
            this.put(sqlCmd, sqlCmd);
        }
    }

    protected void dumpStats() {
        if (!this.keepStats) {
            return;
        }
        System.out.println("Dbs cache statistics:");
        System.out.println(this.hits + " hits");
        System.out.println(this.misses + " misses");
        System.out.println("---------------------------------------------");
    }
}

