/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.XADataSourceSapDB;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class XADataSourceSapDBFactory
implements ObjectFactory {
    static HashSet forbiddenproperties = new HashSet();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if (!"com.sap.dbtech.jdbcext.XADataSourceSapDB".equals(ref.getClassName())) {
                return null;
            }
            Properties p = this.propertiesFromRef(ref);
            XADataSourceSapDB result = new XADataSourceSapDB();
            result.setProperties(p);
            return result;
        }
        return null;
    }

    private Properties propertiesFromRef(Reference ref) {
        Enumeration<RefAddr> refaddrs = ref.getAll();
        Properties result = new Properties();
        while (refaddrs.hasMoreElements()) {
            RefAddr o = refaddrs.nextElement();
            try {
                StringRefAddr stringref = (StringRefAddr)o;
                if (forbiddenproperties.contains(stringref.getType())) continue;
                if (!stringref.getType().equals("isolation")) {
                    result.setProperty(stringref.getType(), (String)stringref.getContent());
                    continue;
                }
                String j2eeisolation = (String)stringref.getContent();
                if (j2eeisolation.equals("none")) continue;
                if (j2eeisolation.equals("ruc")) {
                    j2eeisolation = "TRANSACTION_READ_UNCOMMITTED";
                } else if (j2eeisolation.equals("rc")) {
                    j2eeisolation = "TRANSACTION_READ_COMMITTED";
                } else if (j2eeisolation.equals("rr")) {
                    j2eeisolation = "TRANSACTION_REPEATABLE_READ";
                } else if (j2eeisolation.equals("s")) {
                    j2eeisolation = "TRANSACTION_SERIALIZABLE";
                }
                result.setProperty("isolation", j2eeisolation);
            }
            catch (ClassCastException ccx) {}
        }
        return result;
    }

    static {
        forbiddenproperties.add("autocommit");
    }
}

