/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.io.IOException;
import java.io.InputStream;

public class JoinStream
extends InputStream {
    protected InputStream[] instreams;
    protected InputStream currentStream;
    protected int currentIndex = -1;

    public JoinStream(InputStream[] instreams) {
        this.instreams = instreams;
        this.nextStream();
    }

    protected void nextStream() {
        ++this.currentIndex;
        this.currentStream = this.currentIndex >= this.instreams.length ? null : this.instreams[this.currentIndex];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = 0;
        while (this.currentStream != null && len > 0) {
            int chunkLen = this.currentStream.read(b, off, len);
            if (chunkLen == -1) {
                this.nextStream();
                continue;
            }
            off += chunkLen;
            len -= chunkLen;
            result += chunkLen;
        }
        if (result == 0 && this.currentStream == null) {
            result = -1;
        }
        return result;
    }

    public int read() throws IOException {
        int result = 0;
        while (this.currentStream != null) {
            result = this.currentStream.read();
            if (result != -1) continue;
            this.nextStream();
        }
        if (this.currentStream == null) {
            result = -1;
        }
        return result;
    }

    public void close() throws IOException {
        for (int i = this.currentIndex; i < this.instreams.length; ++i) {
            try {
                if (this.instreams[i] == null) continue;
                this.instreams[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean markSupported() {
        return false;
    }
}

