/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageTranslator {
    private static final String MESSAGES = "com.sap.dbtech.jdbc.messages";
    private static final String MESSAGES_ID_POSTFIX = ".id";
    private static final String SQLSTATE_POSTFIX = ".sqlstate";
    private static HashMap messagebundles = new HashMap();
    private static Object lock = new Object();

    public static String translate(String key) {
        return MessageTranslator.translate(key, null);
    }

    public static String translate(String key, Object o1) {
        Object[] args = new Object[]{o1};
        return MessageTranslator.translate(key, args);
    }

    public static String translate(String key, Object o1, Object o2) {
        Object[] args = new Object[]{o1, o2};
        return MessageTranslator.translate(key, args);
    }

    public static String translate(String key, Object o1, Object o2, Object o3) {
        Object[] args = new Object[]{o1, o2, o3};
        return MessageTranslator.translate(key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getMessages() {
        Object messages = messagebundles.get(Locale.getDefault().toString());
        if (messages == null) {
            Object object = lock;
            synchronized (object) {
                messages = messagebundles.get(Locale.getDefault().toString());
                if (messages == null) {
                    try {
                        messages = ResourceBundle.getBundle(MESSAGES);
                        messagebundles.put(Locale.getDefault().toString(), messages);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
        }
        return (ResourceBundle)messages;
    }

    public static String translate(String key, Object[] args) {
        try {
            String messageText = MessageTranslator.getMessages().getString(key);
            return MessageFormat.format(messageText, args);
        }
        catch (MissingResourceException missingResEx) {
            StringBuffer result = new StringBuffer("No message available for locale ");
            result.append(MessageTranslator.getMessages().getLocale().toString());
            result.append(", key ");
            result.append(key);
            if (args == null || args.length == 0) {
                result.append(".");
            } else {
                result.append(", arguments [");
                for (int i = 0; i < args.length - 1; ++i) {
                    result.append(args[i].toString());
                    result.append(", ");
                }
                result.append(args[args.length - 1].toString());
                result.append("].");
            }
            return result.toString();
        }
        catch (NullPointerException nullpointerex) {
            StringBuffer result = new StringBuffer("No message available for default locale ");
            result.append("for key ");
            result.append(key);
            if (args == null || args.length == 0) {
                result.append(".");
            } else {
                result.append(", arguments [");
                for (int i = 0; i < args.length - 1; ++i) {
                    result.append(args[i].toString());
                    result.append(", ");
                }
                result.append(args[args.length - 1].toString());
                result.append("].");
            }
            return result.toString();
        }
    }

    public static int getMessageID(String key) {
        int messageID = -10899;
        try {
            messageID = Integer.parseInt(MessageTranslator.getMessages().getString(key + MESSAGES_ID_POSTFIX));
        }
        catch (Exception ignore) {
        }
        catch (Error error) {
            // empty catch block
        }
        return messageID;
    }

    public static String getSQLState(String key) {
        String sqlstate = "";
        try {
            sqlstate = MessageTranslator.getMessages().getString(key + SQLSTATE_POSTFIX);
        }
        catch (Exception ignore) {
        }
        catch (Error error) {
            // empty catch block
        }
        return sqlstate;
    }
}

