/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.sap.core.sdk.cmd.OsName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class CommandHelper {
    static final String COMMAND_GROUP = "local-server";
    static final int DEFAULT_SHUTDOWN_PORT = 8003;
    static final int DEFAULT_JMX_PORT = 1717;
    static final int DEFAULT_HTTP_PORT = 8080;
    static final int DEFAULT_HTTPS_PORT = 8443;
    static final int DEFAULT_AJP_PORT = 8009;
    static final int DEFAULT_CONFIG_SERVICE_PORT = 8087;
    static final int CONSOLE_PORT_TIMEOUT = 180;
    static final int DEFAULT_WAIT_URL_TIMEOUT = 180;
    static final String SHUTDOWNPORT_PROPERTY_NAME = "catalina.shutdown.port";
    static final String PARAM_DESCR_LOCATION = "Local server installation directory";
    static final String PARAM_DESCR_SHUTDOWN_PORT = "Shutdown port opened by server (default: 8003)";
    static final String PARAM_DESCR_HTTP_PORT = "HTTP port opened by server (default: 8080)";
    static final String PARAM_DESCR_HTTPS_PORT = "HTTPS port opened by server (default: 8443)";
    static final String PARAM_DESCR_AJP_PORT = "AJP port opened by server (default: 8009)";
    static final String PARAM_DESCR_SERVICE_CONFIG_PORT = "No longer in use, the parameter is only kept for compatibility reasons. A port provided using this parameter will not be used.";
    static final String PARAM_DESCR_JMX_PORT = "JMX port opened by server (default: 1717; JVM system property com.sun.management.jmxremote.port)";
    static final String PARAM_DESCR_HTTP_PROXY_HOST = "JVM system property http.ProxyHost (default: none)";
    static final String PARAM_DESCR_HTTP_PROXY_PORT = "JVM system property http.ProxyPort (default: none)";
    static final String PARAM_DESCR_HTTPS_PROXY_HOST = "JVM system property https.ProxyHost (default: none)";
    static final String PARAM_DESCR_HTTPS_PROXY_PORT = "JVM system property https.ProxyPort (default: none)";
    static final String PARAM_DESCR_HTTP_NON_PROXY_HOSTS = "JVM system property http.nonProxyHosts (default: none)";
    static final String PARAM_DESCR_WAIT_URL = "Waits for a 2xx response from the specified URL before exiting";
    static final String PARAM_DESCR_WAIT_URL_TIMEOUT = "Seconds to wait for a 2xx response from the wait-url before exiting (default: 180)";
    static final String PARAM_DESCR_DEPLOY_SOURCE = "Source for deployment (comma separated list of WAR files or folders containing one or more WAR files)";
    static final String REPOSITORY_PATH = "repository";
    private static final String COMMAND_ARCHIVE = "neo-sdk-cmd-commands";
    private static final String SDK_SUBDIRECTORY_PATH = "tools";
    private static final String DESTINATION_PATH_DEFAULT = "server";
    private static final String SCRIPT_APPENDIX_WINDOWS = ".bat";
    private static final String SCRIPT_APPENDIX_LINUX = ".sh";
    private static File sdkPath = null;
    private static File archivePath = null;

    static File getDefaultServerDestination() {
        File sdkRoot = CommandHelper.getSdkPath();
        if (sdkRoot == null) {
            sdkRoot = new File(".");
        }
        return new File(sdkRoot, DESTINATION_PATH_DEFAULT);
    }

    static File getSdkPath() {
        File serverRepoPath;
        File archivePath;
        if (sdkPath == null && (sdkPath = CommandHelper.traverseUp(archivePath = CommandHelper.getCommandArchivePath())) != null && !(serverRepoPath = new File(sdkPath, REPOSITORY_PATH)).exists()) {
            sdkPath = null;
        }
        return sdkPath;
    }

    static File getCommandArchivePath() {
        if (archivePath == null) {
            String classPath = CommandHelper.getJavaClassPath();
            String path = null;
            for (String s : classPath.split(File.pathSeparator)) {
                if (!s.contains(COMMAND_ARCHIVE)) continue;
                path = s;
                break;
            }
            if (path == null) {
                throw new RuntimeException("Error during SDK path evaluation: java class path didn't contain command archive");
            }
            archivePath = CommandHelper.getCanonicalFile(new File(path));
        }
        return archivePath;
    }

    static void copyFileReplace(File srcFile, File dstFile, String searchText, String replacementText) throws IOException {
        HashMap<String, String> replacements = new HashMap<String, String>(1);
        replacements.put(searchText, replacementText);
        CommandHelper.copyFileReplace(srcFile, dstFile, replacements);
    }

    static void copyFileReplace(File srcFile, File dstFile, Map<String, String> replacements) throws IOException {
        CommandHelper.copyFileReplace(srcFile, dstFile, replacements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFileReplace(File srcFile, File dstFile, Map<String, String> replacements, String append) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(srcFile));
        PrintWriter out = new PrintWriter(new FileWriter(dstFile));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                    line = line.replace(replacement.getKey(), replacement.getValue());
                }
                out.println(line);
            }
            if (append != null) {
                out.println(append);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    static String getOsScriptName(String baseName) {
        return baseName + CommandHelper.getOsScriptAppendix();
    }

    private static String getOsScriptAppendix() {
        switch (OsName.getOsName()) {
            case WINDOWS: {
                return SCRIPT_APPENDIX_WINDOWS;
            }
            case LINUX: 
            case MAC: {
                return SCRIPT_APPENDIX_LINUX;
            }
        }
        throw new IllegalStateException("Failed to determine script appendix.");
    }

    private static String getJavaClassPath() {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            throw new RuntimeException("Error during SDK path evaluation: java.class.path = null");
        }
        return classPath;
    }

    private static File getCanonicalFile(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Error during SDK path evaluation: couldn't get canonical file representation for " + path, e);
        }
    }

    private static File traverseUp(File file) {
        while (file != null && !file.getName().equals(SDK_SUBDIRECTORY_PATH)) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        return file.getParentFile();
    }
}

