/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class Console {
    private String host;
    private int port;
    private SocketChannel channel;
    private ByteBuffer buffer;

    Console(String host, int port) {
        this.host = host;
        this.port = port;
    }

    void connect() throws IllegalStateException {
        this.connectToShutdownPort();
    }

    void command(String command) throws IllegalStateException {
        this.sendCommand(command);
    }

    void close() throws IllegalStateException {
        this.closeChannel();
    }

    private void connectToShutdownPort() {
        try {
            this.channel = SocketChannel.open();
            this.channel.connect(new InetSocketAddress(this.host, this.port));
            this.buffer = ByteBuffer.allocateDirect(1024);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error during connect to local server instance shutdown port at localhost:" + this.port, e);
        }
    }

    private void sendCommand(String command) {
        this.buffer.clear();
        this.buffer.put(command.getBytes());
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while sending command " + command, e);
        }
    }

    private void closeChannel() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while closing connection", e);
        }
    }
}

