/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.sap.core.sdk.cmd.InterruptingStreamHandler;
import com.sap.core.sdk.cmd.PipeStreamReader;

public class Disconnector
extends Thread {
    private final PipeStreamReader outStreamHandler;
    private final PipeStreamReader errStreamHandler;
    private long startTime;

    public Disconnector(PipeStreamReader outStreamHandler, PipeStreamReader errStreamHandler) {
        this.outStreamHandler = outStreamHandler;
        this.errStreamHandler = errStreamHandler;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        while (!this.disconnect()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean disconnect() {
        if (this.disconnectCondition()) {
            this.outStreamHandler.setOutStream(null);
            this.errStreamHandler.setOutStream(null);
            System.out.println(InterruptingStreamHandler.DISCONNECT_SIGNAL_LINE);
            return true;
        }
        return false;
    }

    private boolean disconnectCondition() {
        return System.currentTimeMillis() - this.startTime > 3000L;
    }
}

