/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.sap.core.sdk.cmd.PipeStreamReader;
import java.io.InputStream;

class InterruptingStreamHandler
extends PipeStreamReader {
    static final String DISCONNECT_SIGNAL_LINE = InterruptingStreamHandler.class.getName() + "-DISCONNECT";
    private final Thread interruptedThread;
    private boolean didInterrupt = false;

    InterruptingStreamHandler(InputStream inStream, Thread interruptedThread) {
        super(inStream);
        this.interruptedThread = interruptedThread;
    }

    @Override
    void handleLine(String line) {
        if (line.equals(DISCONNECT_SIGNAL_LINE)) {
            this.didInterrupt = true;
            this.interruptedThread.interrupt();
        } else {
            super.handleLine(line);
        }
    }

    boolean didInterrupt() {
        return this.didInterrupt;
    }
}

