/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.sap.core.sdk.cmd.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class LocalServerConfiguration {
    private static final String HTTP_PORT_XPATH = "/*[name()=\"Server\"]/*[name()=\"Service\"][@name=\"Catalina\"]/*[name()=\"Connector\"][@protocol=\"HTTP/1.1\"]/@port";
    private static final String HTTPS_PORT_XPATH = "/*[name()=\"Server\"]/*[name()=\"Service\"]/*[name()=\"Connector\"][@SSLEnabled=\"true\"]/@port";
    private static final String AJP_PORT_XPATH = "/*[name()=\"Server\"]/*[name()=\"Service\"]/*[name()=\"Connector\"][@protocol=\"AJP/1.3\"]/@port";
    private static final String JMX_PORT_PROPERTY_ASSIGNMENT = "jmxremote.port=";
    private static final String HTTP_PROXY_HOST_PROPERTY_ASSIGNMENT = "http.proxyHost=";
    private static final String HTTP_PROXY_PORT_PROPERTY_ASSIGNMENT = "http.proxyPort=";
    private static final String HTTP_NON_PROXY_HOSTS_PROPERTY_ASSIGNMENT = "http.nonProxyHosts=";
    private static final String HTTPS_PROXY_HOST_PROPERTY_ASSIGNMENT = "https.proxyHost=";
    private static final String HTTPS_PROXY_PORT_PROPERTY_ASSIGNMENT = "https.proxyPort=";
    private final File rootFolder;
    private String httpPort;
    private String httpsPort;
    private String ajpPort;
    private String jmxPort;
    private String shutdownPort;
    private String httpProxy;
    private String httpsProxy;
    private String httpNonProxyHosts;

    LocalServerConfiguration(File rootFolder) {
        this.rootFolder = rootFolder;
    }

    void readFromTomcatConfiguration() {
        File srcConfig = new File(this.rootFolder, "conf/server.xml");
        if (srcConfig.isFile()) {
            try {
                Document configFile = XmlUtil.readXmlFile(srcConfig);
                String port = XmlUtil.getAttributeValue(configFile, HTTP_PORT_XPATH);
                if (port != null) {
                    this.httpPort = port;
                }
                if ((port = XmlUtil.getAttributeValue(configFile, HTTPS_PORT_XPATH)) != null) {
                    this.httpsPort = port;
                }
                if ((port = XmlUtil.getAttributeValue(configFile, AJP_PORT_XPATH)) != null) {
                    this.ajpPort = port;
                }
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXException e) {
            }
            catch (XPathExpressionException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void readFromProperties() {
        File propsFile = new File(this.rootFolder, "props.ini");
        this.httpProxy = "";
        this.httpsProxy = "";
        this.httpNonProxyHosts = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(propsFile));
            while ((line = br.readLine()) != null) {
                int pos = line.indexOf(JMX_PORT_PROPERTY_ASSIGNMENT);
                if (pos >= 0) {
                    this.jmxPort = line.substring(pos + JMX_PORT_PROPERTY_ASSIGNMENT.length());
                }
                if ((pos = line.indexOf(HTTP_PROXY_HOST_PROPERTY_ASSIGNMENT)) >= 0) {
                    this.httpProxy = line.substring(pos + HTTP_PROXY_HOST_PROPERTY_ASSIGNMENT.length());
                }
                if ((pos = line.indexOf(HTTP_PROXY_PORT_PROPERTY_ASSIGNMENT)) >= 0) {
                    this.httpProxy = this.httpProxy + ":" + line.substring(pos + HTTP_PROXY_PORT_PROPERTY_ASSIGNMENT.length());
                }
                if ((pos = line.indexOf(HTTPS_PROXY_HOST_PROPERTY_ASSIGNMENT)) >= 0) {
                    this.httpsProxy = line.substring(pos + HTTPS_PROXY_HOST_PROPERTY_ASSIGNMENT.length());
                }
                if ((pos = line.indexOf(HTTPS_PROXY_PORT_PROPERTY_ASSIGNMENT)) >= 0) {
                    this.httpsProxy = this.httpsProxy + ":" + line.substring(pos + HTTPS_PROXY_PORT_PROPERTY_ASSIGNMENT.length());
                }
                if ((pos = line.indexOf(HTTP_NON_PROXY_HOSTS_PROPERTY_ASSIGNMENT)) < 0) continue;
                this.httpNonProxyHosts = line.substring(pos + HTTP_NON_PROXY_HOSTS_PROPERTY_ASSIGNMENT.length());
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setShutdownPort(int shutdownPort) {
        this.shutdownPort = Integer.toString(shutdownPort);
    }

    void setJmxPort(int jmxPort) {
        this.jmxPort = Integer.toString(jmxPort);
    }

    void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    void setHttpNonProxyHosts(String httpNonProxyHosts) {
        this.httpNonProxyHosts = httpNonProxyHosts;
    }

    void printConfiguration(PrintStream outStream) {
        this.printValue("http-port", this.httpPort, outStream);
        this.printValue("https-port", this.httpsPort, outStream);
        this.printValue("ajp-port", this.ajpPort, outStream);
        this.printValue("jmx-port", this.jmxPort, outStream);
        this.printValue("shutdown-port", this.shutdownPort, outStream);
        this.printValue("http-proxy", this.httpProxy, outStream);
        this.printValue("https-proxy", this.httpsProxy, outStream);
        this.printValue("http-non-proxy-hosts", this.httpNonProxyHosts, outStream);
    }

    private void printValue(String name, String value, PrintStream outStream) {
        if (value != null) {
            value = value.isEmpty() ? "<none>" : value;
            outStream.format("   %1$-21s: %2$s%n", name, value);
        }
    }
}

