/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.sdk.cmd.CommandHelper;
import com.sap.core.sdk.cmd.LocalServerDeployCommandResult;
import com.sap.core.sdk.cmd.LocalServerStarter;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

@Parameters(commandDescription="Deploys WAR files on a local server instance")
public class LocalServerDeployCommand
extends PropertiesCommand {
    static final String SERVER_PICKUPFOLDER_NAME = "webapps";
    private static final String COMMAND_NAME = "deploy-local";
    private List<File> warFiles;
    private File pickupFolder;
    @Parameter(names={"-l", "--location"}, description="Local server installation directory")
    File location = CommandHelper.getDefaultServerDestination();
    @Parameter(names={"-s", "--source"}, description="Source for deployment (comma separated list of WAR files or folders containing one or more WAR files)", required=true)
    String source = null;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return "local-server";
    }

    public void run() throws CommandException {
        this.copyWarFileToPickupFolder();
    }

    public LocalServerDeployCommandResult runForStructuredOutput() throws CommandException {
        this.run();
        return new LocalServerDeployCommandResult(this.warFiles);
    }

    public void init() throws CommandException {
        this.warFiles = this.createWarFileList(this.source.split(","));
        try {
            this.location = LocalServerStarter.checkServerLocation(this.location);
            this.pickupFolder = new File(this.location, SERVER_PICKUPFOLDER_NAME);
            if (!this.pickupFolder.exists()) {
                throw new IllegalStateException("Deploy folder does not exist: " + this.pickupFolder.getAbsolutePath());
            }
        }
        catch (IllegalStateException e) {
            throw new CommandException("No local server instance found in " + this.location.getAbsolutePath(), (Throwable)e, 1);
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 1);
        }
    }

    public void cleanup() throws CommandException {
    }

    private void copyWarFileToPickupFolder() {
        for (File warFile : this.warFiles) {
            System.out.println("Deploying " + warFile.getAbsolutePath());
            this.copyFile(warFile, new File(this.pickupFolder, warFile.getName()));
        }
        System.out.println("Deployment finished successfully");
    }

    private void copyFile(File sourceFile, File targetFile) {
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new CommandException("Unable to copy file " + sourceFile.getAbsolutePath() + " -> " + targetFile.getAbsolutePath(), (Throwable)e, 1);
        }
    }

    private List<File> createWarFileList(String[] paths) {
        List<File> allWarFiles = new ArrayList<File>();
        for (String path : paths) {
            File f = new File(path.trim());
            if (!f.exists()) {
                throw new CommandException("Specified source location does not exist: " + f.getAbsolutePath(), 1);
            }
            if (f.isDirectory()) {
                File[] containedWarFiles = f.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        File warFile = new File(dir, name);
                        return name.toLowerCase(Locale.ENGLISH).endsWith("war") && warFile.canRead();
                    }
                });
                if (containedWarFiles == null || containedWarFiles.length == 0) {
                    throw new CommandException("No WAR found in " + f.getAbsolutePath(), 1);
                }
                allWarFiles.addAll(Arrays.asList(containedWarFiles));
                continue;
            }
            if (f.getName().toLowerCase(Locale.ENGLISH).endsWith("war")) {
                allWarFiles.add(f);
                continue;
            }
            throw new CommandException("Specified source file is not a war: " + f.getAbsolutePath(), 1);
        }
        allWarFiles = this.checkAndRemoveDuplicates(allWarFiles);
        return allWarFiles;
    }

    private List<File> checkAndRemoveDuplicates(List<File> allWarFiles) {
        HashMap<String, File> nameMap = new HashMap<String, File>();
        for (File file : allWarFiles) {
            File duplicateFile = nameMap.put(file.getName(), file);
            try {
                if (duplicateFile == null || duplicateFile.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                throw new CommandException("Duplicate source file names specified: " + file.getAbsolutePath() + " and " + duplicateFile.getAbsolutePath(), 1);
            }
            catch (IOException e) {
                throw new CommandException("IO Problem", (Throwable)e, 1);
            }
        }
        return new ArrayList<File>(nameMap.values());
    }
}

