/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.sdk.cmd.CommandHelper;
import com.sap.core.sdk.cmd.LocalServerConfiguration;
import com.sap.core.sdk.cmd.OsName;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Parameters(commandDescription="Installs a server runtime into a local folder")
public class LocalServerInstallCommand
extends PropertiesCommand {
    private static final String PREFIX_CHECKSUM = "Checksum:";
    private static final String FILENAME_DO_NOT_MODIFY = "DO_NOT_MODIFY";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String COMMAND_NAME = "install-local";
    static final String SERVER_PROPERTIES_FILE = "props.ini";
    static final String SERVER_CONFIG_FILE = "conf/server.xml";
    @Parameter(names={"-l", "--location"}, description="Local server installation directory")
    private File location = CommandHelper.getDefaultServerDestination();
    @Parameter(names={"--jmx-port"}, description="JMX port opened by server (default: 1717; JVM system property com.sun.management.jmxremote.port)")
    private int jmxPort = 1717;
    @Parameter(names={"--http-port"}, description="HTTP port opened by server (default: 8080)")
    private int httpPort = 8080;
    @Parameter(names={"--https-port"}, description="HTTPS port opened by server (default: 8443)")
    private int httpsPort = 8443;
    @Parameter(names={"--ajp-port"}, description="AJP port opened by server (default: 8009)")
    private int ajpPort = 8009;
    @Parameter(names={"--config-service-port"}, description="No longer in use, the parameter is only kept for compatibility reasons. A port provided using this parameter will not be used.", hidden=true)
    private int configServicePort = 8087;
    @Parameter(names={"--http-proxy-host"}, description="JVM system property http.ProxyHost (default: none)")
    private String httpProxyHost = "";
    @Parameter(names={"--http-proxy-port"}, description="JVM system property http.ProxyPort (default: none)")
    private int httpProxyPort = -1;
    @Parameter(names={"--https-proxy-host"}, description="JVM system property https.ProxyHost (default: none)")
    private String httpsProxyHost = "";
    @Parameter(names={"--https-proxy-port"}, description="JVM system property https.ProxyPort (default: none)")
    private int httpsProxyPort = -1;
    @Parameter(names={"--http-non-proxy-hosts"}, description="JVM system property http.nonProxyHosts (default: none)")
    private String httpNonProxyHosts = "";
    private File sdkRootFolder;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return "local-server";
    }

    public void run() throws CommandException {
        try {
            this.copyServerRuntime();
            this.adaptServerConfiguration().printConfiguration(System.out);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 1);
        }
    }

    public void init() throws CommandException {
        this.sdkRootFolder = CommandHelper.getSdkPath();
        if (this.sdkRootFolder == null) {
            throw new CommandException("Unable to determine SDK path. install-local must only be used inside the SAP Cloud Platform SDK for Neo environment.");
        }
        if (!this.httpProxyHost.isEmpty() && this.httpProxyPort == -1) {
            throw new CommandException("httpProxyPort must be configured if httpProxyHost is configured", 1);
        }
        if (this.httpProxyHost.isEmpty() && this.httpProxyPort > 0) {
            throw new CommandException("httpProxyHost must be configured if httpProxyPort is configured", 1);
        }
        if (!this.httpsProxyHost.isEmpty() && this.httpsProxyPort == -1) {
            throw new CommandException("httpsProxyPort must be configured if httpsProxyHost is configured", 1);
        }
        if (this.httpsProxyHost.isEmpty() && this.httpsProxyPort > 0) {
            throw new CommandException("httpsProxyHost must be configured if httpsProxyPort is configured", 1);
        }
        this.checkTargetLocation();
    }

    public void cleanup() throws CommandException {
    }

    private void checkTargetLocation() {
        if (this.location.isDirectory()) {
            File[] destinationContent = this.location.listFiles();
            if (destinationContent != null && destinationContent.length > 0) {
                throw new CommandException(MessageFormat.format("The installation folder {0} must be empty.", this.location.getAbsolutePath()));
            }
        } else if (this.location.exists()) {
            throw new CommandException(MessageFormat.format("The installation folder {0} is not an empty folder.", this.location.getAbsolutePath()));
        }
    }

    private void copyServerRuntime() throws IOException {
        System.out.println("Installing server runtime into local folder:");
        System.out.println(this.location.getCanonicalPath());
        File repositoryFolder = new File(this.sdkRootFolder, "repository");
        this.copyServer(repositoryFolder, this.location);
    }

    private void copyServer(File repositoryFolder, File targetFolder) {
        File serverArchiveFolder = new File(repositoryFolder, ".archive");
        this.verifyRepositoryContent(serverArchiveFolder);
        try {
            FileUtils.copyDirectory((File)serverArchiveFolder, (File)targetFolder);
        }
        catch (IOException e) {
            throw new CommandException(MessageFormat.format("Failed to copy server template to {0}. ", targetFolder.getAbsolutePath()) + e.getMessage(), (Throwable)e, 1);
        }
        if (OsName.getOsName() != OsName.WINDOWS) {
            Collection shellFiles = FileUtils.listFiles((File)targetFolder, (String[])new String[]{"sh"}, (boolean)true);
            for (File file : shellFiles) {
                try {
                    this.setExecutablePermission(file.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new CommandException("Unable to determine canonical path of shell file. IO Exception: " + e.getMessage(), (Throwable)e, 1);
                }
            }
        }
    }

    private void verifyRepositoryContent(File serverArchiveFolder) {
        File checksumFile = new File(serverArchiveFolder.getParentFile(), FILENAME_DO_NOT_MODIFY);
        try {
            String expectedChecksum = this.getExpectedChecksum(checksumFile);
            String checksumStr = this.calculateChecksum(serverArchiveFolder).toString();
            boolean modified = true;
            if (expectedChecksum.length() > 0 && checksumStr.equals(expectedChecksum)) {
                modified = false;
            }
            if (modified) {
                throw new CommandException(MessageFormat.format("The repository folder was modified. If this was not done intentionally you should update the folder from the original SDK zip file." + NEW_LINE + "If you did intentionally modify the installation template you can fix this error by changing the checksum in {0} to {1}", checksumFile, checksumStr), 1);
            }
        }
        catch (IOException e) {
            throw new CommandException("Unable to read repository content: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getExpectedChecksum(File checksumFile) throws IOException {
        List readLines = FileUtils.readLines((File)checksumFile);
        String expectedChecksum = "";
        for (String line : readLines) {
            if (!line.startsWith(PREFIX_CHECKSUM)) continue;
            expectedChecksum = line.substring(PREFIX_CHECKSUM.length()).trim();
            break;
        }
        return expectedChecksum;
    }

    private BigInteger calculateChecksum(File root) throws IOException {
        BigInteger result = BigInteger.ZERO;
        if (root.isDirectory()) {
            for (File f : root.listFiles()) {
                result = result.add(this.calculateChecksum(f));
            }
        } else if (root.isFile()) {
            result = result.add(this.getMd5(new FileInputStream(root)));
        }
        result = result.add(this.getMd5(new ByteArrayInputStream(root.getName().getBytes(Charset.forName("UTF-8")))));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getMd5(InputStream ins) throws IOException {
        try {
            BigInteger bigInteger = new BigInteger(DigestUtils.md5((InputStream)ins));
            return bigInteger;
        }
        finally {
            IOUtils.closeQuietly((InputStream)ins);
        }
    }

    private void setExecutablePermission(String fileName) {
        if (OsName.WINDOWS.equals((Object)OsName.getOsName())) {
            return;
        }
        File file = new File(fileName);
        boolean done = file.setExecutable(true, false);
        if (!done) {
            System.out.println("Unable to set executable flag to file: " + file.getAbsolutePath());
        }
    }

    private LocalServerConfiguration adaptServerConfiguration() throws IOException {
        LocalServerConfiguration localServerConfiguration = new LocalServerConfiguration(this.location);
        this.configureMasterConfig();
        localServerConfiguration.readFromTomcatConfiguration();
        this.configureProperties(localServerConfiguration);
        return localServerConfiguration;
    }

    private void configureMasterConfig() throws IOException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.clear();
        replacements.put("<Server port=\"8005", "<Server port=\"${catalina.shutdown.port}");
        if (8080 != this.httpPort) {
            replacements.put(Integer.toString(8080), Integer.toString(this.httpPort));
        }
        if (8443 != this.httpsPort) {
            replacements.put(Integer.toString(8443), Integer.toString(this.httpsPort));
        }
        if (8009 != this.ajpPort) {
            replacements.put(Integer.toString(8009), Integer.toString(this.ajpPort));
        }
        if (!replacements.isEmpty()) {
            File serverConfigFile = new File(this.location, SERVER_CONFIG_FILE);
            File tmpServerConfigFile = new File(serverConfigFile.getParentFile(), serverConfigFile.getName() + ".org");
            if (!serverConfigFile.renameTo(tmpServerConfigFile)) {
                throw new CommandException(MessageFormat.format("Unable to write server configurations. Failed to rename file {0} to {1}", serverConfigFile.getAbsolutePath(), tmpServerConfigFile.getAbsolutePath()), 1);
            }
            CommandHelper.copyFileReplace(tmpServerConfigFile, serverConfigFile, replacements);
            tmpServerConfigFile.delete();
        }
    }

    private void configureProperties(LocalServerConfiguration configReport) throws IOException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        StringBuilder systemProperties = new StringBuilder();
        systemProperties.append(NEW_LINE + "-D" + "catalina.shutdown.port" + "=" + Integer.toString(8003));
        if (this.jmxPort != -1) {
            systemProperties.append(NEW_LINE + "-Dcom.sun.management.jmxremote.port=");
            systemProperties.append(this.jmxPort);
            systemProperties.append(NEW_LINE + "-Dcom.sun.management.jmxremote.authenticate=false");
            systemProperties.append(NEW_LINE + "-Dcom.sun.management.jmxremote.ssl=false");
            configReport.setJmxPort(this.jmxPort);
        }
        if (!this.httpProxyHost.isEmpty()) {
            systemProperties.append(NEW_LINE + "-Dhttp.proxyHost=");
            systemProperties.append(this.httpProxyHost);
            systemProperties.append(NEW_LINE + "-Dhttp.proxyPort=");
            systemProperties.append(Integer.toString(this.httpProxyPort));
            configReport.setHttpProxy(this.httpProxyHost + ":" + this.httpProxyPort);
        } else {
            configReport.setHttpProxy("");
        }
        if (!this.httpsProxyHost.isEmpty()) {
            systemProperties.append(NEW_LINE + "-Dhttps.proxyHost=");
            systemProperties.append(this.httpsProxyHost);
            systemProperties.append(NEW_LINE + "-Dhttps.proxyPort=");
            systemProperties.append(Integer.toString(this.httpsProxyPort));
            configReport.setHttpsProxy(this.httpsProxyHost + ":" + this.httpsProxyPort);
        } else {
            configReport.setHttpsProxy("");
        }
        if (!this.httpNonProxyHosts.isEmpty()) {
            systemProperties.append(NEW_LINE + "-Dhttp.nonProxyHosts=");
            systemProperties.append(this.httpNonProxyHosts);
            configReport.setHttpNonProxyHosts(this.httpNonProxyHosts);
        } else {
            configReport.setHttpNonProxyHosts("");
        }
        if (systemProperties.length() > 0) {
            replacements.put("#options", "#options" + NEW_LINE + systemProperties);
        }
        if (!replacements.isEmpty()) {
            File serverPropsFile = new File(this.location, SERVER_PROPERTIES_FILE);
            File tmpPropsFile = new File(serverPropsFile.getParentFile(), serverPropsFile.getName() + ".org");
            if (!serverPropsFile.renameTo(tmpPropsFile)) {
                throw new CommandException(MessageFormat.format("Unable to write server configurations. Failed to rename file {0} to {1}", serverPropsFile.getAbsolutePath(), tmpPropsFile.getAbsolutePath()), 1);
            }
            CommandHelper.copyFileReplace(tmpPropsFile, serverPropsFile, replacements);
            tmpPropsFile.delete();
        }
    }
}

