/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.sdk.cmd.CommandHelper;
import com.sap.core.sdk.cmd.Console;
import com.sap.core.sdk.cmd.InterruptingStreamHandler;
import com.sap.core.sdk.cmd.LocalServerConfiguration;
import com.sap.core.sdk.cmd.LocalServerStarter;
import com.sap.core.sdk.cmd.LocalServerStopCommand;
import com.sap.core.sdk.cmd.XmlUtil;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.net.ServerSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;

@Parameters(commandDescription="Starts a local server instance")
public class LocalServerStartCommand
extends PropertiesCommand {
    private static final long POLL_PERIOD = 1000L;
    private static final String COMMAND_NAME = "start-local";
    @Parameter(names={"-l", "--location"}, description="Local server installation directory")
    private File location = CommandHelper.getDefaultServerDestination();
    @Parameter(names={"--shutdown-port"}, description="Shutdown port opened by server (default: 8003)")
    private int shutdownPort = 8003;
    @Parameter(names={"--wait-url"}, description="Waits for a 2xx response from the specified URL before exiting")
    private String waitUrl = "";
    @Parameter(names={"--wait-url-timeout"}, description="Seconds to wait for a 2xx response from the wait-url before exiting (default: 180)")
    private int waitUrlTimeout = 180;
    private URL waitUrlChecked = null;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return "local-server";
    }

    public void run() throws CommandException {
        try {
            this.startLocalServer();
            this.waitForConsole();
            this.waitForURL();
            this.getLocalServerConfiguration().printConfiguration(System.out);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 1);
        }
    }

    public void init() throws CommandException {
        if (!this.waitUrl.isEmpty()) {
            try {
                this.waitUrlChecked = new URL(this.waitUrl);
            }
            catch (MalformedURLException e) {
                throw new CommandException("Invalid URL: " + this.waitUrl, (Throwable)e, 1);
            }
        }
        if (this.waitUrlTimeout < 0) {
            throw new CommandException("waitUrlTimeout must be >=0", 1);
        }
        try {
            this.location = LocalServerStarter.checkServerLocation(this.location);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 1);
        }
        File serverXmlFile = new File(this.location, "conf/server.xml");
        try {
            Document configFile = XmlUtil.readXmlFile(serverXmlFile);
            String shutdownCmd = XmlUtil.getAttributeValue(configFile, "/*[name()=\"Server\"]/@shutdown");
            if (!"SHUTDOWN".equals(shutdownCmd)) {
                throw new CommandException(MessageFormat.format("The 'Server' configuration must define the attribute shutdown=\"{0}\". Found attribute value {1} in server configuration file {2}", "SHUTDOWN", shutdownCmd, serverXmlFile.getAbsolutePath()), 1);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(MessageFormat.format("Unable to parse local server configuration file {0}", serverXmlFile.getAbsolutePath()), (Throwable)e, 1);
        }
        try {
            ServerSocketFactory.getDefault().createServerSocket(this.shutdownPort).close();
        }
        catch (IOException e) {
            throw new CommandException("Shutdown port:" + this.shutdownPort + " already in use", 1);
        }
    }

    public void cleanup() throws CommandException {
    }

    private void startLocalServer() throws CommandException, IOException {
        block5: {
            Process process;
            System.out.println("Starting local server instance");
            String commandArchivePath = CommandHelper.getCommandArchivePath().getCanonicalPath();
            ArrayList<String> command = new ArrayList<String>();
            String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            command.add(jvm);
            command.add("-cp");
            command.add(commandArchivePath);
            command.add(LocalServerStarter.class.getName());
            command.add(this.location.getCanonicalPath());
            command.add(Integer.toString(this.shutdownPort));
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                throw new CommandException("Unable to start process", (Throwable)e, 1);
            }
            InterruptingStreamHandler outputHandler = new InterruptingStreamHandler(process.getInputStream(), Thread.currentThread());
            outputHandler.setOutStream(System.out);
            InterruptingStreamHandler errorHandler = new InterruptingStreamHandler(process.getErrorStream(), Thread.currentThread());
            errorHandler.setOutStream(System.err);
            outputHandler.start();
            errorHandler.start();
            try {
                int exitValue = process.waitFor();
                if (exitValue != 0) {
                    throw new CommandException("Process exits with code " + exitValue, 1);
                }
            }
            catch (InterruptedException e) {
                if (outputHandler.didInterrupt()) break block5;
                throw new CommandException("Unexpected interrupt", (Throwable)e, 1);
            }
        }
    }

    private void waitForConsole() {
        boolean connected = false;
        Console console = new Console("localhost", this.shutdownPort);
        long startTime = System.currentTimeMillis();
        while (!connected && (System.currentTimeMillis() - startTime) / 1000L < 180L) {
            try {
                console.connect();
                connected = true;
            }
            catch (Exception exception) {
                LocalServerStartCommand.waitBeforeRetry();
            }
        }
        if (!connected) {
            throw new CommandException("Console port connection timeout", 1);
        }
        System.out.println("Checked connection to server on console port " + this.shutdownPort);
        console.close();
    }

    private void waitForURL() {
        if (this.waitUrlChecked != null) {
            System.out.println("Waiting for " + this.waitUrlChecked);
            System.out.println("Wait timeout: " + (this.waitUrlTimeout == 0 ? " infinite" : this.waitUrlTimeout + " seconds"));
            boolean connected = false;
            HttpURLConnection urlConnection = null;
            long startTime = System.currentTimeMillis();
            if (this.waitUrlTimeout == 0) {
                this.waitUrlTimeout = Integer.MAX_VALUE;
            }
            while (!connected && (System.currentTimeMillis() - startTime) / 1000L < (long)this.waitUrlTimeout) {
                try {
                    urlConnection = (HttpURLConnection)this.waitUrlChecked.openConnection();
                    urlConnection.setConnectTimeout(1000);
                    urlConnection.setRequestMethod("HEAD");
                    if (this.waitUrlChecked.getUserInfo() != null) {
                        String basicAuth = "Basic " + new String(new Base64().encode(this.waitUrlChecked.getUserInfo().getBytes()));
                        urlConnection.setRequestProperty("Authorization", basicAuth);
                    }
                    urlConnection.connect();
                    int responseCode = urlConnection.getResponseCode();
                    connected = responseCode >= 200 && responseCode < 300;
                    if (connected) continue;
                    LocalServerStartCommand.waitBeforeRetry();
                }
                catch (Exception exception) {
                    LocalServerStartCommand.waitBeforeRetry();
                }
            }
            if (connected) {
                System.out.println("Connected to URL after " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
                urlConnection.disconnect();
            } else {
                System.out.println("URL connection timeout. Stopping local server instance");
                LocalServerStopCommand.stopLocalServer(this.shutdownPort);
                throw new CommandException("URL connection timeout", 1);
            }
        }
    }

    private LocalServerConfiguration getLocalServerConfiguration() {
        LocalServerConfiguration localServerConfiguration = new LocalServerConfiguration(this.location);
        localServerConfiguration.readFromTomcatConfiguration();
        localServerConfiguration.readFromProperties();
        localServerConfiguration.setShutdownPort(this.shutdownPort);
        return localServerConfiguration;
    }

    private static void waitBeforeRetry() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

