/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.sap.core.sdk.cmd.CommandHelper;
import com.sap.core.sdk.cmd.Disconnector;
import com.sap.core.sdk.cmd.PipeStreamReader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class LocalServerStarter {
    private static final String ENVIRONMENT_VAR_JAVA_OPTS = "JAVA_OPTS";
    private static final String SERVER_START_SCRIPT_BASE = "startup";
    private static final String SETENVFILE_BASE = "setenv";
    private File serverLocation;
    private int consolePort;

    public static void main(String[] args) {
        int exitVal = new LocalServerStarter(args).startLocalServer();
        System.exit(exitVal);
    }

    private LocalServerStarter(String[] args) {
        this.serverLocation = new File(args[0]);
        this.consolePort = Integer.parseInt(args[1]);
    }

    private int startLocalServer() {
        try {
            this.serverLocation = LocalServerStarter.checkServerLocation(this.serverLocation);
            Process process = this.startProcess();
            int exitVal = process.waitFor();
            return exitVal;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 1;
        }
        catch (IllegalStateException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private Process startProcess() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        File serverBinFolder = new File(this.serverLocation, "bin");
        File startScript = new File(serverBinFolder, LocalServerStarter.getServerStartScriptName());
        command.add(startScript.getCanonicalPath());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(this.serverLocation);
        String java_opts = processBuilder.environment().get(ENVIRONMENT_VAR_JAVA_OPTS);
        java_opts = (java_opts == null ? "" : java_opts) + " -D" + "catalina.shutdown.port" + "=" + this.consolePort;
        processBuilder.environment().put(ENVIRONMENT_VAR_JAVA_OPTS, java_opts);
        Process process = processBuilder.start();
        PipeStreamReader outStreamHandler = new PipeStreamReader(process.getInputStream());
        outStreamHandler.setOutStream(System.out);
        outStreamHandler.start();
        PipeStreamReader errStreamHandler = new PipeStreamReader(process.getErrorStream());
        errStreamHandler.setOutStream(System.err);
        errStreamHandler.start();
        Disconnector disconnector = new Disconnector(outStreamHandler, errStreamHandler);
        disconnector.start();
        return process;
    }

    private static String getServerStartScriptName() {
        return CommandHelper.getOsScriptName(SERVER_START_SCRIPT_BASE);
    }

    static File checkServerLocation(File serverLocation) throws IllegalStateException, IOException {
        File[] serverInstallationCheckFiles;
        for (File checkFile : serverInstallationCheckFiles = new File[]{new File(serverLocation, "bin/" + LocalServerStarter.getServerStartScriptName()), new File(serverLocation, "bin/" + CommandHelper.getOsScriptName(SETENVFILE_BASE)), new File(serverLocation, "conf/server.xml")}) {
            if (checkFile.exists()) continue;
            boolean usingDefaultLocation = serverLocation.getCanonicalPath().equals(CommandHelper.getDefaultServerDestination().getCanonicalPath());
            StringBuilder errorMsg = new StringBuilder();
            if (usingDefaultLocation) {
                errorMsg.append("The default location {0} does not point to a valid server installation directory. The file {1} does not exist. Use parameter -l to provide a valid local server installation location or run the 'install-local' command to create a new one.");
            } else {
                errorMsg.append("The provided location {0} does not point to a valid server installation directory. The file {1} does not exist.");
            }
            throw new IllegalStateException(MessageFormat.format(errorMsg.toString(), serverLocation.getCanonicalPath(), checkFile.getCanonicalPath()));
        }
        return serverLocation.getCanonicalFile();
    }
}

