/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.sdk.cmd.Console;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Stops a local server instance")
public class LocalServerStopCommand
extends PropertiesCommand {
    static final String SHUTDOWN_CMD = "SHUTDOWN";
    private static final String COMMAND_NAME = "stop-local";
    @Parameter(names={"--shutdown-port"}, description="Shutdown port opened by server (default: 8003)")
    private int shutdownPort = 8003;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return "local-server";
    }

    public void run() throws CommandException {
        LocalServerStopCommand.stopLocalServer(this.shutdownPort);
    }

    public void init() throws CommandException {
    }

    public void cleanup() throws CommandException {
    }

    static void stopLocalServer(int shutDownPort) throws CommandException {
        System.out.println("Stopping local server instance");
        try {
            Console console = new Console("localhost", shutDownPort);
            console.connect();
            console.command(SHUTDOWN_CMD);
            console.close();
        }
        catch (IllegalStateException e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 1);
        }
    }
}

