/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.client;

import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import com.sap.cloud.crypto.keystore.service.ext.KeyStoreServiceExt;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class KeystoreObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new NameNotFoundException("Object [" + obj + "] is not instance of [" + Reference.class.getName() + "]");
        }
        Reference objReference = (Reference)obj;
        String refClassName = objReference.getClassName();
        if (!refClassName.equals(KeyStoreService.class.getName()) && !refClassName.equals(KeyStoreServiceExt.class.getName())) {
            throw new NameNotFoundException("Object reference class name [" + refClassName + "] is not of types [KeyStoreService, KeyStoreServiceExt]");
        }
        if (refClassName.equals(KeyStoreService.class.getName())) {
            return this.getObject(KeyStoreService.class);
        }
        return this.getObject(KeyStoreServiceExt.class);
    }

    <T> T getObject(Class<T> clazz) throws NameNotFoundException {
        ServiceLoader<T> objects = ServiceLoader.load(clazz, this.getClass().getClassLoader());
        Iterator<T> it = objects.iterator();
        if (!it.hasNext()) {
            throw new NameNotFoundException("Unable to get object " + clazz.getName());
        }
        return it.next();
    }
}

