/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.service.ClientSideKeyStore;
import com.sap.cloud.crypto.keystore.service.KeyStoreValueReader;
import com.sap.cloud.crypto.keystore.service.cache.Cache;
import com.sap.cloud.crypto.keystore.service.cache.CacheEntry;
import com.sap.cloud.crypto.keystore.service.properties.PropertiesManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAccessor {
    private final ConcurrentMap<String, Cache<ClientSideKeyStore>> cache = new ConcurrentHashMap<String, Cache<ClientSideKeyStore>>();
    private static final CacheAccessor INSTANCE = new CacheAccessor();
    private static final Logger LOG = LoggerFactory.getLogger(CacheAccessor.class);
    private long cacheValidityPeriodInMillieconds = (long)PropertiesManager.getInstance().getCacheValidityPeriodInSeconds() * 1000L;
    private long cacheLastAccessTimeoutInMilliseconds = (long)PropertiesManager.getInstance().getCacheLastAccessTimeoutInSeconds() * 1000L;

    private CacheAccessor() {
    }

    public static CacheAccessor getInstance() {
        return INSTANCE;
    }

    public void setTimeouts(long cacheValidityPeriodInMilliseconds, long cacheLastAccessTimeoutInMilliseconds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting new cache timeouts: [cacheValidityPeriodInMilliseconds]: " + cacheValidityPeriodInMilliseconds + ", [cacheLastAccessTimeoutInMilliseconds]: " + cacheLastAccessTimeoutInMilliseconds);
        }
        this.cacheValidityPeriodInMillieconds = cacheValidityPeriodInMilliseconds;
        this.cacheLastAccessTimeoutInMilliseconds = cacheLastAccessTimeoutInMilliseconds;
        for (Map.Entry entry : this.cache.entrySet()) {
            Cache tenantCache = (Cache)entry.getValue();
            if (tenantCache == null) continue;
            tenantCache.setValueTimeout(this.cacheValidityPeriodInMillieconds);
            tenantCache.setLastAccessTimeout(this.cacheLastAccessTimeoutInMilliseconds);
        }
    }

    public ClientSideKeyStore getCachedKeyStore(String tenantName, String keyStoreName) throws Exception {
        Cache<ClientSideKeyStore> tenantCache = null;
        tenantCache = (Cache<ClientSideKeyStore>)this.cache.get(tenantName);
        if (tenantCache == null) {
            tenantCache = new Cache<ClientSideKeyStore>(new KeyStoreValueReader(tenantName), this.cacheValidityPeriodInMillieconds, this.cacheLastAccessTimeoutInMilliseconds);
            Cache<ClientSideKeyStore> tempCache = this.cache.putIfAbsent(tenantName, tenantCache);
            if (tempCache != null) {
                tenantCache = tempCache;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created new tenant cache for keystore: " + keyStoreName);
            }
        }
        CacheEntry cacheEntry = tenantCache.getCacheEntry(keyStoreName);
        return (ClientSideKeyStore)cacheEntry.getValue();
    }

    public void invalidate(String tenantName) {
        this.cache.remove(tenantName);
    }
}

