/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.KeyStoreSpiWrapperImpl;
import java.security.KeyStore;
import java.security.Provider;

public class ClientSideKeyStore
extends KeyStore {
    private KeyStoreSpiWrapperImpl keyStoreSpi;

    public ClientSideKeyStore(KeyStoreSpiWrapperImpl keyStoreSpi, Provider provider, String type) throws KeyStoreServiceException {
        super(keyStoreSpi, provider, type);
        this.keyStoreSpi = keyStoreSpi;
        try {
            this.load(null, null);
        }
        catch (Exception e) {
            throw new KeyStoreServiceException("Client side keystore could not be initialized", (Throwable)e);
        }
    }

    public long getVersionStamp() {
        return this.keyStoreSpi.getKeystoreData().getVersionStamp();
    }

    public void load(char[] password) throws KeyStoreServiceException {
        this.keyStoreSpi.getKeystoreData().load(password);
        if (this.keyStoreSpi.isExaminableStorage()) {
            this.keyStoreSpi.setPassword(password);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SAP HANA Cloud KeyStore").append("\r\n");
        builder.append(" name   : ").append(this.keyStoreSpi.getKeystoreData().getName()).append("\r\n");
        builder.append(" type   : ").append(this.keyStoreSpi.getKeystoreData().getKeyStore().getType()).append("\r\n");
        builder.append(" version: ").append(this.getVersionStamp()).append("\r\n");
        builder.append(" level : ").append((Object)this.keyStoreSpi.getKeystoreData().getStorageLevel()).append("\r\n");
        return builder.toString();
    }
}

