/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtil {
    public static final String DOMAINDB_DEST = "domaindb";
    private static final String SPACE_PROPERTIES_FILE = "space.properties";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static Properties spaceProps;

    static boolean isDomainDBAvailable() {
        return System.getenv("HC_LANDSCAPE") != null;
    }

    static synchronized Properties getSpaceProperties() {
        if (spaceProps == null) {
            spaceProps = ConfigurationUtil.loadFileProperties(SPACE_PROPERTIES_FILE);
        }
        return spaceProps;
    }

    private static Properties loadFileProperties(String fileName) {
        File file = new File(fileName);
        Properties sapceProps = new Properties();
        try {
            sapceProps.load(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.error("Problem while loading properties from file: " + fileName, (Throwable)e);
        }
        return sapceProps;
    }
}

