/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.crypto.keystore.api.KeyStoreNotFoundException;
import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.ConfigurationUtil;
import com.sap.cloud.crypto.keystore.service.DomainDBConfigurationData;
import com.sap.cloud.crypto.keystore.service.DomainDBKeyStore;
import com.sap.cloud.crypto.keystore.service.KeyStoreCloudStorage;
import com.sap.cloud.crypto.keystore.service.KeyStoreData;
import com.sap.cloud.crypto.keystore.service.KeyStoreDomainDBReadException;
import com.sap.cloud.crypto.keystore.service.StorageLevel;
import com.sap.cloud.crypto.keystore.service.ext.KeyStoreAlreadyExistsException;
import com.sap.core.jpaas.security.utils.Base64;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreDomainDBStorage
implements KeyStoreCloudStorage {
    private static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String UTF_8 = "UTF-8";
    private static final String ACCOUNT_SPACE_PROPERTY_KEY = "jpSpace";
    private static final String ACCOUNT_ENV_KEY = "HC_ACCOUNT";
    private static final String APPLICATION_SPACE_PROPERTY_KEY = "jpApp";
    private static final String APPLICATION_ENV_KEY = "HC_APPLICATION";
    private static final String NO_KEYSTORE_PATH = "";
    private static final String KEYSTORE_PATH_TEMPLATE_FOR_APPLICATION_LEVEL = "rest/configuration/account/%s/application/%s/keystore/%s";
    private static final String KEYSTORE_PATH_TEMPLATE_FOR_SUBSCRIPTION_LEVEL = "rest/configuration/account/%s/application/%s/tenant/%s/keystore/%s";
    private static final String KEYSTORE_PATH_TEMPLATE_FOR_TENANT_LEVEL = "rest/configuration/tenant/%s/keystore/%s";
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreDomainDBStorage.class);
    private String tenantId;

    public KeyStoreDomainDBStorage(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Set<String> getKeyStoreNames() {
        HashSet<String> result = new HashSet<String>();
        Set<Object> listKeystores = new HashSet(0);
        try {
            String cfgSubscriptionUrl = this.getSubscriptionPath(this.tenantId, null);
            listKeystores = this.listKeyStores(cfgSubscriptionUrl);
            result.addAll(listKeystores);
            logger.debug("Added keystores from subscription: {}", listKeystores);
        }
        catch (KeyStoreServiceException e) {
            logger.error("The keystores from subscription level can't be read.", (Throwable)e);
        }
        String cfgTenantUrl = this.getTenantPath(this.tenantId, null);
        listKeystores = this.listKeyStores(cfgTenantUrl);
        result.addAll(listKeystores);
        logger.debug("Added keystores from tenant: {}", listKeystores);
        try {
            String cfgApplicationUrl = this.getApplicationPath(null);
            listKeystores = this.listKeyStores(cfgApplicationUrl);
            result.addAll(listKeystores);
            logger.debug("Added keystores from application: {}", listKeystores);
        }
        catch (KeyStoreServiceException e) {
            logger.error("The keystores from application level can't be read.", (Throwable)e);
        }
        return result;
    }

    private Set<String> listKeyStores(String cfgUrl) {
        Set<String> result = new HashSet<String>(0);
        try {
            String response = this.fetchDomainDBResponse(cfgUrl);
            if (response != null) {
                result = (Set)new Gson().fromJson(response, new TypeToken<Set<String>>(){}.getType());
            }
        }
        catch (Exception e) {
            logger.error("Could not list available keystores in the Domain DB under path: " + cfgUrl, (Throwable)e);
        }
        return result;
    }

    @Override
    public KeyStoreData getKeyStore(String name) throws KeyStoreServiceException {
        KeyStoreData keystore = null;
        keystore = this.getKeyStoreAtSubscriptionLevel(name);
        if (keystore == null) {
            keystore = this.getKeyStoreAtTenantLevel(name);
        }
        if (keystore == null) {
            keystore = this.getKeyStoreAtApplicationLevel(name);
        }
        return keystore;
    }

    private KeyStoreData getKeyStoreAtSubscriptionLevel(String name) throws KeyStoreServiceException {
        KeyStoreData result = null;
        result = this.readKeyStore(this.getSubscriptionPath(this.tenantId, name), name, StorageLevel.SUBSCRIPTION);
        return result;
    }

    private KeyStoreData getKeyStoreAtTenantLevel(String name) throws KeyStoreServiceException {
        KeyStoreData result = null;
        result = this.readKeyStore(this.getTenantPath(this.tenantId, name), name, StorageLevel.TENANT);
        return result;
    }

    private KeyStoreData getKeyStoreAtApplicationLevel(String name) throws KeyStoreServiceException {
        KeyStoreData result = null;
        result = this.readKeyStore(this.getApplicationPath(name), name, StorageLevel.APPLICATION);
        return result;
    }

    private KeyStoreData readKeyStore(String cfgUrl, String name, StorageLevel storageLevel) throws KeyStoreServiceException {
        String response = this.fetchDomainDBResponse(cfgUrl);
        if (response == null) {
            return null;
        }
        DomainDBKeyStore domainDBKeyStore = this.parseDomainDBKeyStore(response, cfgUrl);
        String type = domainDBKeyStore.getType();
        byte[] keyStoreContent = Base64.decode((String)domainDBKeyStore.getContent());
        KeyStoreData result = new KeyStoreData(name, type, domainDBKeyStore.getModified(), keyStoreContent, storageLevel);
        return result;
    }

    private DomainDBKeyStore parseDomainDBKeyStore(String response, String cfgUrlForTrace) throws KeyStoreServiceException {
        DomainDBKeyStore domainDBKeyStore;
        String contentString;
        DomainDBConfigurationData cfgData;
        try {
            cfgData = (DomainDBConfigurationData)new Gson().fromJson(response, DomainDBConfigurationData.class);
        }
        catch (JsonSyntaxException e) {
            throw new KeyStoreDomainDBReadException("Keystore configuration in Domain DB under path: " + cfgUrlForTrace + " is not a valid JSON. Content: " + response, e);
        }
        byte[] content = cfgData.getContent();
        if (content == null) {
            throw new KeyStoreDomainDBReadException("Keystore configuration in Domain DB under path '" + cfgUrlForTrace + "' does not have content");
        }
        try {
            contentString = new String(content, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreDomainDBReadException("Keystore configuration content from Domain DB cannot be read", e);
        }
        try {
            domainDBKeyStore = (DomainDBKeyStore)new Gson().fromJson(contentString, DomainDBKeyStore.class);
        }
        catch (JsonSyntaxException e) {
            throw new KeyStoreServiceException("Content stored as keystore configuration in Domain DB under path: " + cfgUrlForTrace + " is not a valid JSON. Content: " + contentString, (Throwable)e);
        }
        if (this.isEmpty(domainDBKeyStore.getName())) {
            throw new KeyStoreServiceException("JSon content stored as keystore configuration in Domain DB under path: " + cfgUrlForTrace + " does not have value for field `name`");
        }
        if (this.isEmpty(domainDBKeyStore.getType())) {
            throw new KeyStoreServiceException("JSon content stored as keystore configuration in Domain DB under path: " + cfgUrlForTrace + " does not have value for field `type`");
        }
        if (this.isEmpty(domainDBKeyStore.getContent())) {
            throw new KeyStoreServiceException("JSon content stored as keystore configuration in Domain DB under path: " + cfgUrlForTrace + " does not have value for field `content`");
        }
        return domainDBKeyStore;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    private String fetchDomainDBResponse(String configurationPath) throws KeyStoreServiceException {
        Response response;
        block5: {
            response = null;
            try {
                logger.debug("Read keystore configuration from Domain DB under path: [{}] ", (Object)configurationPath);
                response = new DomainDBConnection().execute(this.createGetRequest(configurationPath));
                if (!response.is(404)) break block5;
                logger.debug("Keystore configuration is not found in the Domain DB under path:");
                return null;
            }
            catch (ConnectionException e) {
                if (response == null) {
                    throw new KeyStoreDomainDBReadException("Could not obtain keystore configuration from Domain DB.", e);
                }
                throw new KeyStoreDomainDBReadException("Could not obtain keystore configuration from Domain DB. Received status code: " + response.getStatus() + " and response:\n" + response.asString(), e);
            }
        }
        if (response.isNotOK()) {
            String errorMessage = "Keystore configuration was not retrieved successfully. Status code:" + response.getStatus() + " and response:\\n [" + response.asString() + "]";
            logger.error(errorMessage);
            throw new KeyStoreServiceException(errorMessage);
        }
        logger.debug("Obtained keystore configuration from Domain DB:\n [{}]", (Object)response);
        return response.asString();
    }

    private Request<HttpURLConnection> createGetRequest(String configurationPath) {
        return (Request)new URLRequest.Builder().withPath(configurationPath).withGETMethod().withHeader(ACCEPT_HEADER, APPLICATION_JSON_CONTENT_TYPE).build();
    }

    private String getSubscriptionPath(String tenantId, String keyStorePath) throws KeyStoreServiceException {
        Properties spaceProperties = ConfigurationUtil.getSpaceProperties();
        String account = this.findAccount(spaceProperties);
        String application = this.findApplication(spaceProperties);
        if (account == null || application == null) {
            String errorMessage = "Could not perform operation on subscription level, because the application or account property is empty. Obtained properties: jpSpace=" + account + ", " + APPLICATION_SPACE_PROPERTY_KEY + "=" + application;
            logger.error(errorMessage);
            throw new KeyStoreServiceException(errorMessage);
        }
        return String.format(KEYSTORE_PATH_TEMPLATE_FOR_SUBSCRIPTION_LEVEL, account, application, tenantId, this.getKeyStorePathIfPresented(keyStorePath));
    }

    private String getTenantPath(String tenantId, String keyStorePath) {
        return String.format(KEYSTORE_PATH_TEMPLATE_FOR_TENANT_LEVEL, tenantId, this.getKeyStorePathIfPresented(keyStorePath));
    }

    private String getApplicationPath(String keyStorePath) throws KeyStoreServiceException {
        Properties spaceProperties = ConfigurationUtil.getSpaceProperties();
        String account = this.findAccount(spaceProperties);
        String application = this.findApplication(spaceProperties);
        if (account == null || application == null) {
            String errorMessage = "Could not perform operation on application level, because the application or account property is empty. Obtained properties: jpSpace=" + account + ", " + APPLICATION_SPACE_PROPERTY_KEY + "=" + application;
            logger.error(errorMessage);
            throw new KeyStoreServiceException(errorMessage);
        }
        return String.format(KEYSTORE_PATH_TEMPLATE_FOR_APPLICATION_LEVEL, account, application, this.getKeyStorePathIfPresented(keyStorePath));
    }

    private String getKeyStorePathIfPresented(String keyStorePath) {
        return keyStorePath != null ? keyStorePath : NO_KEYSTORE_PATH;
    }

    private String findAccount(Properties spaceProperties) {
        String propretyValue = spaceProperties.getProperty(ACCOUNT_SPACE_PROPERTY_KEY);
        if (propretyValue == null) {
            propretyValue = System.getenv(ACCOUNT_ENV_KEY);
        }
        return propretyValue;
    }

    private String findApplication(Properties spaceProperties) {
        String propretyValue = spaceProperties.getProperty(APPLICATION_SPACE_PROPERTY_KEY);
        if (propretyValue == null) {
            propretyValue = System.getenv(APPLICATION_ENV_KEY);
        }
        return propretyValue;
    }

    @Override
    public void uploadKeyStore(String name, String type, byte[] content, boolean overwrite) throws KeyStoreAlreadyExistsException, KeyStoreServiceException {
        this.uploadKeyStoreAtSubscriptionLevel(name, type, content, overwrite);
    }

    @Override
    public void uploadKeyStoreAtSubscriptionLevel(String name, String type, byte[] content, boolean overwrite) throws KeyStoreAlreadyExistsException, KeyStoreServiceException {
        logger.debug("Uploading keystore with name {} and type {} for current subsciption", (Object)name, (Object)type);
        if (!overwrite && this.checkExistenceAtSubscriptionLevel(name)) {
            throw new KeyStoreAlreadyExistsException("Keystore with name " + name + " already exists for this subscription.");
        }
        String path = this.getSubscriptionPath(this.tenantId, name);
        this.storeKeyStoreInDomainDB(name, path, type, content);
    }

    @Override
    public void uploadKeyStoreAtApplicationLevel(String name, String type, byte[] content, boolean overwrite) throws KeyStoreAlreadyExistsException, KeyStoreServiceException {
        logger.debug("Uploading keystore with name {} and type {} for current application", (Object)name, (Object)type);
        if (!overwrite && this.checkExistenceAtApplicationLevel(name)) {
            throw new KeyStoreAlreadyExistsException("Keystore with name " + name + " already exists for this application.");
        }
        String path = this.getApplicationPath(name);
        this.storeKeyStoreInDomainDB(name, path, type, content);
    }

    private void storeKeyStoreInDomainDB(String name, String configurationPath, String type, byte[] content) throws KeyStoreServiceException {
        Response response = null;
        try {
            try {
                String entity = this.getKeyStoreJson(name, type, content);
                response = new DomainDBConnection().execute(this.createPostRequest(configurationPath, entity));
                if (response.isNotOK()) {
                    String errorMessage = "Keystore with name [" + name + "] was not uploaded successfully. Status code:" + response.getStatus() + " and response:\n [" + response.asString() + "]";
                    logger.error(errorMessage);
                    throw new KeyStoreServiceException(errorMessage);
                }
                logger.debug("Keystore with name [{}] is uploaded successfully.", (Object)name);
            }
            catch (Exception e) {
                throw new KeyStoreServiceException("Could not upload keystore with name " + name + " to domain DB", (Throwable)e);
            }
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    private Request<HttpURLConnection> createPostRequest(String configurationPath, String entity) {
        return (Request)new URLRequest.Builder().withPath(configurationPath).withPOSTMethod().withContentType("application/octet-stream").withEntity(entity).build();
    }

    @Override
    public void deleteKeyStore(String name) throws KeyStoreNotFoundException, KeyStoreServiceException {
        this.deleteKeyStoreAtSubscriptionLevel(name);
    }

    @Override
    public void deleteKeyStoreAtSubscriptionLevel(String name) throws KeyStoreNotFoundException, KeyStoreServiceException {
        logger.debug("Deleting keystore with name " + name + " from domain DB for current subsciption");
        if (!this.checkExistenceAtSubscriptionLevel(name)) {
            throw new KeyStoreNotFoundException("Keystore with name " + name + " doesn't exist for this subscription.");
        }
        String path = this.getSubscriptionPath(this.tenantId, name);
        this.deleteKeyStoreFromDomainDB(name, path);
    }

    @Override
    public void deleteKeyStoreAtApplicationLevel(String name) throws KeyStoreNotFoundException, KeyStoreServiceException {
        logger.debug("Deleting keystore with name {} from domain DB for current application", (Object)name);
        if (!this.checkExistenceAtApplicationLevel(name)) {
            throw new KeyStoreNotFoundException("Keystore with name " + name + " doesn't exist for this application");
        }
        String path = this.getApplicationPath(name);
        this.deleteKeyStoreFromDomainDB(name, path);
    }

    private void deleteKeyStoreFromDomainDB(String name, String configurationPath) throws KeyStoreServiceException {
        Response response = null;
        try {
            try {
                response = new DomainDBConnection().execute(this.createDeleteRequest(configurationPath));
                if (response.isNotOK()) {
                    String errorMessage = "Keystore with name [" + name + "] was not deleted successfully. Status code:" + response.getStatus() + " and response:\n [" + response.asString() + "]";
                    logger.error(errorMessage);
                    throw new KeyStoreServiceException(errorMessage);
                }
                logger.debug("Keystore with name [{}] is deleted successfully.", (Object)name);
            }
            catch (Exception e) {
                throw new KeyStoreServiceException("Could not delete keystore with name " + name + " from domain DB", (Throwable)e);
            }
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    private Request<HttpURLConnection> createDeleteRequest(String configurationPath) {
        return (Request)new URLRequest.Builder().withPath(configurationPath).withDELETEMethod().build();
    }

    private String getKeyStoreJson(String name, String type, byte[] content) throws IOException {
        DomainDBKeyStore keyStore = new DomainDBKeyStore(name, type, System.currentTimeMillis(), Base64.encode((byte[])content));
        String keyStoreJson = new Gson().toJson((Object)keyStore);
        return keyStoreJson;
    }

    private boolean checkExistenceAtSubscriptionLevel(String name) throws KeyStoreServiceException, KeyStoreAlreadyExistsException {
        return this.getKeyStoreAtSubscriptionLevel(name) != null;
    }

    private boolean checkExistenceAtApplicationLevel(String name) throws KeyStoreServiceException, KeyStoreAlreadyExistsException {
        return this.getKeyStoreAtApplicationLevel(name) != null;
    }
}

