/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.KeyStoreData;
import com.sap.cloud.crypto.keystore.service.KeyStoreExaminableStorage;
import com.sap.cloud.crypto.keystore.service.StorageLevel;
import com.sap.cloud.crypto.keystore.service.types.TypesMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreFileStorage
implements KeyStoreExaminableStorage {
    private static final String KEYSTORE_STORAGE_DIR = String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.cloud.crypto.keystore";
    private static final String KEYSTORE_METACONFIG = "metaconfig.json";
    private static final String KEYSTORE_CFG_PROPS = "keystore_cfg.props";
    private static final char DOT = '.';
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreFileStorage.class);

    @Override
    public KeyStoreData getKeyStore(String name) throws KeyStoreServiceException {
        if (name == null) {
            throw new KeyStoreServiceException("Keystore name is required");
        }
        File storageDir = new File(KEYSTORE_STORAGE_DIR);
        File[] keyStoreFiles = null;
        KeyStoreData result = null;
        if (storageDir.exists()) {
            keyStoreFiles = storageDir.listFiles(new GetKeyStoreFilter(name));
            switch (keyStoreFiles.length) {
                case 0: {
                    LOG.debug("Could not found keystore with name: '{}' on the file system under path: {}", (Object)name, (Object)new File(KEYSTORE_STORAGE_DIR).getAbsolutePath());
                    break;
                }
                case 1: {
                    String type = this.getKeystoreTypeFromFileName(keyStoreFiles[0].getName());
                    result = this.readKeyStoreData(name, type, keyStoreFiles[0]);
                    LOG.debug("Keystore with name: '{}' and type: '{}' is found on the file system under path: '{}'", new Object[]{name, type, storageDir.getAbsolutePath()});
                    break;
                }
                default: {
                    throw new KeyStoreServiceException("Found more than one keystore files with the same name: " + name + ". Found files: " + Arrays.asList(keyStoreFiles));
                }
            }
        }
        return result;
    }

    private static final String formKeyStoreFileName(String name, String type) {
        return String.valueOf(KEYSTORE_STORAGE_DIR) + File.separator + name + '.' + type;
    }

    private KeyStoreData readKeyStoreData(String name, String keystoreType, File keyStoreFile) throws KeyStoreServiceException {
        KeyStoreData result;
        block16: {
            byte[] content;
            InputStream inputStream = null;
            long lastModified = keyStoreFile.lastModified();
            try {
                inputStream = new FileInputStream(keyStoreFile);
                content = this.readInputStream(inputStream);
            }
            catch (FileNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Keystore with name '" + name + "' is not found on the file system.", (Throwable)e);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        LOG.debug("Could not close keystore file: " + keyStoreFile, (Throwable)e2);
                    }
                }
                return null;
            }
            catch (IOException e) {
                throw new KeyStoreServiceException("Failed to read keystore with name '" + name + "' from the file system.", (Throwable)e);
            }
            result = new KeyStoreData(name, keystoreType, lastModified, content, StorageLevel.FILE_SYSTEM);
            LOG.debug("Key store data loaded {}", (Object)result);
            break block16;
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.debug("Could not close keystore file: " + keyStoreFile, (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] tmp = new byte[4096];
        int ret = 0;
        while ((ret = is.read(tmp)) >= 0) {
            bos.write(tmp, 0, ret);
        }
        return bos.toByteArray();
    }

    @Override
    public boolean isKeyStoreChanged(String name, String type, long versionStamp) {
        long lastModified;
        boolean result = false;
        String keyStoreFilePathName = KeyStoreFileStorage.formKeyStoreFileName(name, type);
        File keyStoreFile = new File(keyStoreFilePathName);
        if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
            LOG.debug("KeyStore file with path: {} is not existing anymore. It is probably deleted since the last load", (Object)keyStoreFilePathName);
            result = true;
        }
        if ((lastModified = keyStoreFile.lastModified()) != versionStamp) {
            LOG.debug("KeyStore file with path: {} was modified since the last load. Previous modification stamp: {}, current modification stamp: {}", new Object[]{keyStoreFilePathName, versionStamp, lastModified});
            result = true;
        }
        return result;
    }

    @Override
    public Set<String> getKeyStoreNames() {
        return this.listStorageDir();
    }

    private Set<String> listStorageDir() {
        HashSet<String> result = new HashSet<String>();
        String[] names = this.getFileNames();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String keyStoreName = this.getKeystoreNameFromFileName(name);
                if (!result.add(keyStoreName)) {
                    result.remove(keyStoreName);
                    if (LOG.isWarnEnabled()) {
                        HashSet<String> repeatingNames = new HashSet<String>();
                        String[] stringArray2 = names;
                        int n3 = names.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String fileName = stringArray2[n4];
                            if (keyStoreName.equals(this.getKeystoreNameFromFileName(fileName))) {
                                repeatingNames.add(fileName);
                            }
                            ++n4;
                        }
                        LOG.warn("Found several keystores with the same name [{}]: {}", (Object)keyStoreName, repeatingNames);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private String[] getFileNames() {
        File storageDir = new File(KEYSTORE_STORAGE_DIR);
        if (storageDir.exists()) {
            return storageDir.list(new KeyStoreListFilter(null, null));
        }
        return null;
    }

    private boolean isSystemFile(String name) {
        return KEYSTORE_CFG_PROPS.equals(name) || KEYSTORE_METACONFIG.equals(name);
    }

    private String getKeystoreNameFromFileName(String filename) {
        return filename.substring(0, filename.lastIndexOf(46));
    }

    private String getKeystoreTypeFromFileName(String filename) throws KeyStoreServiceException {
        int dot_pos = filename.lastIndexOf(46);
        if (dot_pos == -1) {
            throw new KeyStoreServiceException("Unknown keystore type for file '" + filename + "'");
        }
        String fileExtension = filename.substring(dot_pos + 1);
        return TypesMapper.getKeyStoreType(fileExtension);
    }

    private class GetKeyStoreFilter
    extends KeyStoreListFilter {
        private String keystoreName;

        public GetKeyStoreFilter(String keystoreName) {
            this.keystoreName = keystoreName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return super.accept(dir, name) && this.keystoreName.equals(KeyStoreFileStorage.this.getKeystoreNameFromFileName(name));
        }
    }

    private class KeyStoreListFilter
    implements FilenameFilter {
        private KeyStoreListFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (KeyStoreFileStorage.this.isSystemFile(name)) {
                return false;
            }
            int dotIndex = name.lastIndexOf(46);
            return dotIndex > 0 && dotIndex < name.length() - 1;
        }

        /* synthetic */ KeyStoreListFilter(KeyStoreListFilter keyStoreListFilter, KeyStoreListFilter keyStoreListFilter2) {
            this();
        }
    }
}

